(in-package "ACL2")

;integerp-minus-aux
(encapsulate ()

             (local (defthm minus-1-rewrite
                      (equal (* -1 x)
                             (- x))))

             (local (defthm integerp-minus-forward
                      (implies (acl2-numberp x)
                               (implies (integerp (* -1 x))
                                        (integerp x)))))
             
             (local (defthm integerp-minus-backward
                      (implies (acl2-numberp x)
                               (implies (integerp x)
                                        (integerp (* -1 x))))))
             
             (defthm integerp-minus-aux
               (implies (acl2-numberp x) ;gen?
                        (equal (integerp (* -1 x))
                               (integerp x)))
               :hints (("Goal" :in-theory (disable integerp-minus-forward integerp-minus-backward)
                        :use ( integerp-minus-forward integerp-minus-backward)))))

(include-book "negative-syntaxp")

(defthm integerp-minus
  (implies (and (syntaxp (negative-syntaxp x)) ;the negative-syntaxp test makes this rule quite general
                (case-split (acl2-numberp x))
                )
           (equal (integerp x)
                  (integerp (* -1 x)))))

(in-theory (disable integerp-minus-aux))


(include-book "fp2")


#|
 
 simplify integerp of a sum. see robert krug's meta rules on this subject

|#

(encapsulate ()
             (local (defthm forward
                      (implies (integerp n)
                               (implies (integerp (+ n x))
                                        (integerp (fix x))))))

             (local (defthm backward
                      (implies (integerp n)
                               (implies (integerp (fix x))
                                        (integerp (+ n x))))))

             (defthm integerp-sum-take-out-known-integer
               (implies (integerp n)
                        (and (equal (integerp (+ n x))
                                    (integerp (fix x)))
                             (equal (integerp (+ x n))
                                    (integerp (fix x)))))
               :hints (("Goal" :in-theory (disable forward backward)
                        :use (forward backward)))))

(defthm integerp-sum-take-out-known-integer-3
  (implies (integerp n)
           (and ;(equal (integerp (+ n x y))      ;this case not needed?
                 ;      (integerp (fix (+ x y))))
                (equal (integerp (+ x n y))
                       (integerp (fix (+ x y))))
                (equal (integerp (+ x y n))
                       (integerp (fix (+ x y))))))
  :hints (("Goal" :in-theory (disable integerp-sum-take-out-known-integer)
           :use (:instance  integerp-sum-take-out-known-integer (x (+ x y))))))



#|
 
 simplify integerp of a product. see robert krug's meta rules on this subject

|#

(defthm integerp-prod
  (implies (and (integerp x)
                (integerp y))
           (integerp (* x y)))
  :rule-classes (:rewrite :type-prescription))

;are these expensive?
(defthm integerp-prod-of-3-last-two
  (implies (and (integerp (* b c))
                (integerp a))
           (integerp (* a b c))))

(defthm integerp-prod-of-3-first-and-last
  (implies (and (integerp (* a c))
                (integerp b))
           (integerp (* a b c)))
  :hints (("Goal" :in-theory (disable integerp-prod-of-3-last-two)
           :use (:instance integerp-prod-of-3-last-two (a b) (b a)))))

(defthm integerp-prod-of-3-first-two
  (implies (and (integerp (* a b))
                (integerp c))
           (integerp (* a b c)))
  :hints (("Goal" :in-theory (disable integerp-prod-of-3-last-two 
                                      integerp-prod-of-3-first-and-last)
           :use (:instance integerp-prod-of-3-last-two (a c) (c a)))))


;a funny little rule:

;should be in even-odd?
;can be expensive!
;perhaps should export disabled
;make a forward-chaining rule?
(defthm even-int-implies-int
  (implies (and (integerp (* 1/2 x))
                (rationalp x))
           (integerp x))
  :rule-classes ((:rewrite :backchain-limit-lst (1 nil)))
  :hints (("Goal" :in-theory (disable integerp-prod)
           :use (:instance integerp-prod (x (* 1/2 x)) (y 2)))))

(in-theory (disable even-int-implies-int))

;forces the constant to be in the range [0,1)  (and for 0, will be simplified further)
(defthm integerp-+-reduce-leading-constant
  (implies (syntaxp (and (quotep k)
                         (or (>= (cadr k) 1) (< (cadr k) 0))))
           (equal (integerp (+ k x))
                  (integerp (+ (+ k (- (floor k 1))) x))))) ;use mod?
                


(defthm rationalp-*-when-first-factor-is-rat
  (implies (and (rationalp x)
                (case-split (not (equal x 0))) ;if x is 0, then...
                )
           (equal (rationalp (* x y))
                  (not (complex-rationalp y)))))