(in-package "ACL2")
;(include-book "include-book-macros")


(include-book "ground-zero") ; move up
(local (include-book "numerator"))
(local (include-book "denominator"))
(local (include-book "nniq"))
(local (include-book "arith2"))
(local (include-book "type"))
(local (include-book "ground-zero"))
(local (include-book "flooreric"))
(local (include-book "integerp"))
(local (include-book "rationalp"))
(local (include-book "unary-divide"))
(local (include-book "expt"))
(local (include-book "expt2"))
(include-book "expo")
(local (include-book "expo2"))
(local (include-book "power2p"))
(local (include-book "fl-expt"))
(local (include-book "mod2"))
(local (include-book "even-odd"))
(include-book "mod")
;(include-book "factor-2")
;(include-book "remmod")
(include-book "mod-expt")
(include-book "bits2")

(include-book "rtl")

;(in-theory (disable expt-inverse))

(defun bitn (x n)
  (bits x n n))

(in-theory (disable bitn))

(defthm bitn-non-negative-integer
  (and (integerp (bitn x n))
       (<= 0 (bitn x n)))
  :hints (("Goal" :in-theory (enable bitn)))
  :rule-classes (:rewrite :type-prescription))




(encapsulate
 ()
;gen
 (local (defthm bitn-upper-bound-case-1
          (implies (integerp n)
                   (<= (bitn x n) 1))
          :otf-flg t
          :hints (("Goal" :use (:instance fl-def-linear-part-2 (x (* 1/2 X (/ (EXPT 2 N)))))
                   :in-theory (set-difference-theories
                               (enable mod bitn bits expt-split)
                               '( fl-def-linear-part-2
                                  a10
;                          REARRANGE-ERIC-4
                                  REARRANGE-FRACTIONAL-COEFS-<
                                  ))))
          :rule-classes (:rewrite :linear)))
;separate out the linear rule?

 (local (defthm bitn-upper-bound-case-2
          (implies (not (integerp n))
                   (<= (bitn x n) 1))
          :otf-flg t
          :hints (("Goal" :cases ((integerp (+ n 1)))
                   :in-theory (set-difference-theories
                               (enable mod bitn bits expt-split)
                               '(A10
                                 fl-def-linear-part-2
                                 REARRANGE-FRACTIONAL-COEFS-<))))
          :rule-classes (:rewrite :linear)))



 (defthm bitn-upper-bound
   (<= (bitn x n) 1)
   :hints (("Goal" :cases ((integerp n)))))
 )

(defthm bitn-upper-bound-linear
  (<= (bitn x n) 1)
  :rule-classes ((:LINEAR :TRIGGER-TERMS ((bitn x n)))))


(encapsulate
 ()
;derive from bits-minus?
 (local (defthm bitn-minus-case-1
          (implies (and (rationalp x)
                        (integerp n)
                        (integerp (/ x (expt 2 (+ 1 n))))
                        )
                   (equal (bitn (* -1 x) n)
                          (- (bitn x n))
                          ))
          :hints (("Goal" :in-theory (set-difference-theories
                                      (enable bitn 
                                              bits
                                              mod-cancel
                                              expt-pull-negation-out-of-power  
                                              expt-split)
                                      '( ;expt-inverse ; BITS-N-N-REWRITE
                                        ))))))


 (local (defthm bitn-minus-case-2
          (implies (and (rationalp x)
                        (integerp n)
                        (not (integerp (/ x (expt 2 n))))
                        )
                   (equal (bitn (* -1 x) n)
                          (- 1 (bitn x n))
                          ))
          :hints (("Goal" :in-theory (set-difference-theories
                                      (enable bitn
                                              mod
                                              mod-cancel
                                              bits 
                                              even-int-implies-int
                                              expt-pull-negation-out-of-power  
                                              expt-split)
                                      '( ;expt-inverse
;BITS-N-N-REWRITE
                                        ))))))


 (local (defthm bitn-minus-case-3
          (implies (and (rationalp x)
                        (integerp n)
                        (not (integerp (/ x (expt 2 (+ 1 n)))))
                        (integerp (/ x (expt 2 n)))
                        )
                   (equal (bitn (* -1 x) n)
                          (- 2 (bitn x n))
                          ))
          :hints (("Goal" :in-theory (set-difference-theories
                                      (enable bitn
                                              mod
                                              mod-cancel
                                              bits 
                                              expt-pull-negation-out-of-power  
                                              expt-split)
                                      '( ;expt-inverse
                                        ))))))





 (defthm bitn-minus
   (implies (and (syntaxp (negative-syntaxp x))
                 (case-split (rationalp x)) ;gen?
                 (case-split (integerp n))
                 )
            (equal (bitn x n)
                   (if (integerp (/ x (expt 2 (+ 1 n))))
                       (- (bitn (- x) n))
                     (if (integerp (/ x (expt 2 n)))
                         (- 2 (bitn (- x) n))
                       (- 1 (bitn (- x) n))))))))



;(in-theory (disable  FL-EQUAL-0))

;1 rewrite to odd?
(defthm bitn-0-rewrite-to-even
  (implies (integerp x)
           (equal (equal (bitn x 0) 0)
                  (integerp (* 1/2 x))))
  :hints (("Goal" :in-theory (enable bitn bits)))
  )


;...


;(in-theory (disable  bitn-sum-lowbits)) ;was causing loops


;this one should remain last?
(theory-invariant (incompatible (:rewrite bits-n-n-rewrite-to-bitn)
                                (:definition bitn)
                                )
                  :key bitn-and-bits-n-n-shouldnt-alternate)

(defthm bits-n-n-rewrite-to-bitn
  (equal (BITS X n n)
         (bitn x n))
  :hints (("Goal" :in-theory (enable bitn)))
  )

(in-theory (disable bits-n-n-rewrite-to-bitn))

(in-theory (enable bitn))


#|
;should only fire if it really does simplify x, that is, if x really has bits to be dropped
(defthm bitn-sum-simplify-first-term
  (implies (and (>= (abs x) (expt 2 (+ n 1))) ;prevents loop
                (rationalp x)
                (rationalp y)
                (integerp n))
           (equal (bitn (+ x y) n)
                  (bitn (+ (lowbits x n) y) n)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable 
                               lowbits
                               bitn bits)
                              '(BITS-N-N-REWRITE-TO-BITN)))))

;should only fire if it really does simplify y, that is, if y really has bits to be dropped
(defthm bitn-sum-simplify-second-term
  (implies (and (>= (abs y) (expt 2 (+ n 1))) ;prevents loop
                (rationalp x)
                (rationalp y)
                (integerp n))
           (equal (bitn (+ x y) n)
                  (bitn (+ x (lowbits y n)) n)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable lowbits
                                      bitn bits)
                              '(BITS-N-N-REWRITE-TO-BITN)))))



(in-theory (current-theory :here))

(defthm bitn-sum-simplify-third-term
  (implies (and (>= (abs z) (expt 2 (+ n 1))) ;prevents loop
                (rationalp x)
                (rationalp y)
                (rationalp z)
                (integerp n))
           (equal (bitn (+ x y z) n)
                  (bitn (+ x y (lowbits z n)) n)))
  :hints (("Goal" :in-theory (disable bitn-sum-simplify-first-term
                                      bitn-sum-simplify-second-term)
           :use (:instance bitn-sum-simplify-first-term (x z) (y (+ x y))))))



|#


(defthm bitn-upper-bound-2
  (< (bitn x n) 2)
  :hints (("Goal" :in-theory (disable  bitn-upper-bound)
           :use  bitn-upper-bound)))

(defthm bitn-0-1
  (or (equal (bitn x n) 0)
      (equal (bitn x n) 1))
  :hints (("Goal" :in-theory (disable bitn)))
  :rule-classes nil)


;my strategey with the rules below is to rewrite prefer (not (equal (bitn x n) 0)) over (equal (bitn x n) 1)
;this allows subsumption to ...

;bad to have both?
(defthm bitn-not-0-means-1
  (equal (not (equal (bitn x n) 0))
         (equal (bitn x n) 1))
  :hints (("Goal" :use bitn-0-1)))

(defthm bitn-not-1-means-0
  (equal (not (equal (bitn x n) 1))
         (equal (bitn x n) 0))
  :hints (("Goal" :use bitn-0-1)))

;these are bad rules?
(in-theory (disable bitn-not-1-means-0 bitn-not-0-means-1))


(in-theory (disable bitn))

(encapsulate 
 ()
 (local (defthm bitn-bitn-case-1
          (implies (case-split (integerp n))
                   (equal (bitn (bitn x n) 0)
                          (bitn x n)))
          :hints (("Goal"
                   :in-theory (set-difference-theories
                               (enable bitn bits)
                               '(bits-n-n-rewrite-to-bitn))))))


 (local (defthm bitn-bitn-case-2
          (implies (not (integerp n))
                   (equal (bitn (bitn x n) 0)
                          (bitn x n)))
          :hints (("Goal" :cases ((acl2-numberp n))
                   :in-theory (set-difference-theories
                               (enable bitn bits mod)
                               '(bits-n-n-rewrite-to-bitn))))))

 (defthm bitn-bitn
   (equal (bitn (bitn x n) 0)
          (bitn x n))))



;bb
(defthm bitn-known-not-0-replace-with-1
  (implies (not (equal (bitn x n) 0)) ; backchain-limit?
           (equal (bitn x n)
                  1))
  :rule-classes ((:rewrite :backchain-limit-lst (1)))
  :hints (("Goal" :use (:instance bitn-0-1)))
  )



;needed?
(defthm bitn->-0
  (equal (< 0 (bitn x n))
         (not (equal 0 (bitn x n)))))

(defthm bitn-<-1
  (equal (< (BITN X n) 1)
         (equal (BITN X n) 0))
  :hints (("Goal"
           :use bitn-0-1)))

;useful if bitn-upper-bound and bitn-upper-bound-2 are disabled
(defthm bitn-not->-1
  (implies (and (syntaxp (quotep k))
                (<= 1 k))
           (equal (< k (bitN x n))
                  nil))
  :hints (("Goal" :in-theory (disable bitn-upper-bound bitn-upper-bound-2)
           :use bitn-upper-bound)))


;useful if bitn-upper-bound and bitn-upper-bound-2 are disabled
(defthm bitn-<=-1
  (implies (and (syntaxp (quotep k))
                (< 1 k))
           (equal (< (bitN x n) k)
                  t))
    :hints (("Goal" :in-theory (disable  BITN-NOT->-1 bitn-upper-bound bitn-upper-bound-2)
           :use bitn-upper-bound)))

#|
;cc
(defthm bitn-shift-alt
  (implies (and (syntaxp (should-have-a-2-factor-divided-out x))
                (> n 0) ;restricts application 
                (rationalp x)
                (integerp n)
                )
           (equal (bitn x n)
                  (bitn (/ x 2) (- n 1))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable bits bitn)
                              '(bits-shift-alt
                                bits-n-n-rewrite-to-bitn))
           :use (:instance bits-shift-alt (i n) (j n)))))
|#

(local (in-theory (disable  BITS-N-N-REWRITE-TO-BITN)))

(defthm bitn-def-mod
  (implies (case-split (integerp n))
           (equal (bitn x n)
                  (mod (fl (/ x (expt 2 n)))
                       2)))
  :hints (("Goal" :in-theory (enable bits bitn expt-split))))
(in-theory (disable bitn-def-mod))


(defun not-eric (x)
  (if (equal x 0)
      1
    0))



#|
;this does most of the work (i.e., it gets the constant below 2^i+1
(defthm bitn-sum-lowbits
  (implies (and (syntaxp (and (quotep x) (>= (cadr x) (expt 2 (+ 1 (cadr n)))))) ;dropped negative case
                (rationalp x)
                (rationalp y)
                (integerp n)
                )
           (equal (bitn (+ x              y) n)
                  (bitn (+ (lowbits x n) y) n)))
  :hints (("Goal" :in-theory (enable bitn)
           :use  (:instance bits-sum-lowbits (i n) (j n) ))))
|#

(defthm bitn-drop-crucial-bit-and-flip-result
  (implies (and (case-split (rationalp x))
                (case-split (integerp n)) ;drop?
                )
           (and (equal (bitn (+ (expt 2 n) x) n)
                       (not-eric (bitn x n)))
                (equal (bitn (+ x (expt 2 n)) n)
                       (not-eric (bitn x n)))))
  :otf-flg t
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable bits bitn-def-mod
                                      expt-split
                                      )
                              '(bits-n-n-rewrite-to-bitn
                                MOD-PULL-INSIDE-FL-SHIFT-ALT-ALT-ALT-ALT
                                floor-fl)))))

(defthm bitn-drop-crucial-bit-and-flip-result-alt-gen
  (implies (and (syntaxp (and (quotep j) 
                              (< (cadr j) (expt 2 (+ 1 (cadr n)))) ;bitn-sum-lowbits does most of the work
                              (>= (cadr j) (expt 2 (cadr n)))))
                (rationalp j)
                (rationalp x)
                (integerp n)
                )
           (equal (bitn (+ j x) n)
                  (not-eric (bitn (+ (- j (expt 2 n)) x) n))))
  :otf-flg t
  :hints (("Goal" :in-theory (disable bitn-drop-crucial-bit-and-flip-result)
           :use (:instance bitn-drop-crucial-bit-and-flip-result (x (+ j (- (expt 2 n)) x))))))

;for negative constants j
;might be slow if the negative constant has a large absolute value
;make a negative version of bitn-sum-lowbits
(defthm bitn-add-crucial-bit-and-flip-result
  (implies (and (syntaxp (and (quotep j) 
                              (quotep n)
                              (< (cadr j) 0)))
                (rationalp j)
                (rationalp x)
                (integerp n)
                )
           (equal (bitn (+ j x) n)
                  (not-eric (bitn (+ (+ j (expt 2 n)) x) n))))
  :otf-flg t
  :hints (("Goal" :in-theory (disable  bitn-drop-crucial-bit-and-flip-result)
           :use (:instance bitn-drop-crucial-bit-and-flip-result (x (+ j  x))))))



(defthm bitn-equal-to-silly-value
  (implies (and (syntaxp (quotep k))
                (not (or (equal 0 k) (equal 1 k)))
                )
           (equal (equal k (bitn x n))
                  nil)))
                         



(defthm bitn-split-around-zero
  (implies (and (<= (- (expt 2 n)) x)
                (< x (expt 2 n))
                (rationalp x)
                (integerp n)
                )
           (equal (equal (bitn x n) 0)
                  (<= 0 x)))
  :otf-flg t
  :hints (("Goal" :cases ((<= 0 x))
           :in-theory (enable bitn bits expt-split)))
  )


;drop silly hyps like: (<= -128 (BITN (*::EX1_SRC_RECIP) 24))
(defthm bitn-drop-silly-bound
  (implies (and (syntaxp (quotep k))
                (<= k 0)
                )
  (equal (< (bitn x n) k)
         nil)))

(defthm bitn-drop-silly-bound-2
  (implies (and (syntaxp (quotep k))
                (< k 0)
                )
  (equal (< k (bitn x n))
         t)))


(defthm bitn-even-means-0
  (equal (INTEGERP (* 1/2 (BITN x n)))
         (equal (bitn x n) 0)))


;new - export disabled?
;back-chain-limit?
;new - export disabled?
(defthm bitn-too-small
  (implies (and (< x (expt 2 n))
                (<= 0 x)
                (case-split (rationalp x))
                (case-split (integerp n))
                )
           (equal (bitn x n)
                  0))
  :hints (("Goal" :in-theory (enable bitn bits expt-split)))
  :rule-classes ((:rewrite :backchain-limit-lst (1 nil nil nil)))
  )

(defthm bitn-normal-form
  (equal (equal (bitn x n) 1)
         (not (equal (bitn x n) 0))))


(defthm bitn-of-non-rational
  (implies (not (rationalp x))
           (equal (bitn x n)
                  0))
  :hints (("Goal" :in-theory (enable bitn)))
)


(local (include-book "bvecp")) ;to get bvecp-longer
 


(encapsulate
 ()
 (local (defthm bitn-bvecp-simple
   (bvecp (bitn x n) 1)
   :hints (("Goal" :use bitn-0-1
            :in-theory (set-difference-theories
                        (enable bvecp)
                        '(bits-n-n-rewrite-to-bitn)
                        )))))

 (defthm bitn-bvecp
   (implies (and (<= 1 k)
                 (case-split (integerp k)))
            (bvecp (bitn x n) k))
   :hints (("Goal" :use  bitn-bvecp-simple
            :in-theory (disable bitn-bvecp-simple
                              bits-n-n-rewrite-to-bitn))))
 )

(defthm bitn-times-fraction-integerp 
  (implies (and (not (integerp k))
                (case-split (acl2-numberp k))
                )
           (equal (INTEGERP (* k (BITN x n)))
                  (equal (BITN x n) 0))))



(defthm bitn-in-product-split-cases
  (and (implies (case-split (acl2-numberp k))
                (equal (* (bitn x n) k)
                       (if (equal (bitn x n) 0)
                           0
                         k)))
       (implies (case-split (acl2-numberp k))
                (equal (* k (bitn x n))
                       (if (equal (bitn x n) 0)
                           0
                         k)))))
;(in-theory (disable bitn-in-product-split-cases))

(defthm bitn-in-sum-split-cases
  (and (implies (case-split (acl2-numberp k))
                (equal (+ k (bitn x n))
                       (if (equal (bitn x n) 0)
                           k
                         (+ k 1))))
  
       (implies (case-split (acl2-numberp k))
                (equal (+ (bitn x n) k)
                       (if (equal (bitn x n) 0)
                           k
                         (+ k 1))))))
;(in-theory (disable bitn-in-sum-split-cases))

#|
(defthm bitn-shift-better
  (implies (and (bind-free (can-take-out-numeric-power-of-2 x) (c))
                (force (power2p c))
                (case-split (integerp n))
                )
           (equal (bitn x n)
                  (bitn (/ x c) (- n (expo c)))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable bitn)
                              '(bits-shift-better)
                              )
           :use (:instance bits-shift-better (i n) (j n)))))

|#

(defthm bitn-0
  (equal (bitn 0 k) 0)
  :hints (("goal" :in-theory (enable bitn))))