(in-package "ACL2")

(include-book "rem")

(defun BITN (x n)
  (if (logbitp n x) 1 0))

(local
 (defthm bitn-def-1
     (implies (and (integerp x)
		   (>= x 0))
	      (iff (evenp x)
		   (= (fl (/ x 2))  (/ x 2))))
   :rule-classes ()))

(local
 (defthm bitn-def-2
     (implies (and (rationalp x) (rationalp y))
	      (iff (= x y) (= (* 2 x) (* 2 y))))
   :rule-classes ()))

(local
 (defthm bitn-def-3
     (implies (and (integerp x)
		   (>= x 0))
	      (iff (evenp x)
		   (= (* 2 (fl (/ x 2)))
		      x)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bitn-def-1)
			 (:instance bitn-def-2 (x (/ x 2)) (y (fl (/ x 2)))))))))

(defthm bitn-def-4
     (implies (and (integerp x)
		   (>= x 0))
	      (iff (evenp x)
		   (= (rem x 2) 0)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bitn-def-3)
			 (:instance rem-fl (m x) (n 2))))))

(local
 (defthm bitn-def-5
   (implies (and (integerp x)
                 (integerp n)
                 (>= x 0)
                 (>= n 0))
            (iff (= (bitn x n) 0)
                 (evenp (fl (/ x (expt 2 n))))))
   :rule-classes ()
   :hints (("Goal" :use ((:instance floor-fl (m x) (n (expt 2 n))))))))  

(local
 (defthm bitn-def-6
   (implies (and (integerp x)
                 (integerp n)
                 (>= x 0)
                 (>= n 0))
            (iff (= (bitn x n) 0)
                 (= (rem (fl (/ x (expt 2 n)))
                         2)
                    0)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bitn-def-4 (x (fl (/ x (expt 2 n)))))
                         (:instance bitn-def-5))))))



(defthm BITN-DEF
  (implies (and (integerp x)
                (integerp k)
                (>= x 0)
                (>= k 0))
           (equal (bitn x k)
                  (rem (fl (/ x (expt 2 k)))
                       2)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-def-6 (n k))
                        (:instance rem012 (x (fl (/ x (expt 2 k)))))))))

(in-theory (disable bitn))

(defthm BITN-ALT-0
  (implies (and (integerp x)
                (>= x 0))
           (equal (bitn x 0)
                  (rem x 2)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-def (k 0))))))

(defthm BITN-ALT-POS
  (implies (and (integerp x)
                (integerp k)
                (>= x 0)
                (> k 0))
           (equal (bitn x k)
                  (bitn (fl (/ x 2)) (1- k))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-def)
                        (:instance bitn-def (x (fl (/ x 2))) (k (1- k)))
                        (:instance fl/int-rewrite (x (/ x 2)) (n (expt 2 (1- k))))))))

(local
 (defthm bit-rem-1
   (implies (and (integerp x)
                 (integerp n)
                 (integerp k)
                 (>= x 0)
                 (>= k 0)
                 (> n k))
            (equal (bitn x k)
                   (rem (fl (/ (+ (* (expt 2 n) (fl (/ x (expt 2 n))))
                                  (rem x (expt 2 n)))
                               (expt 2 k)))
                        2)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bitn-def)
			 (:instance rem-fl (m x) (n (expt 2 n))))))))

(local
 (defthm bit-rem-2
    (implies (and (integerp x)
		  (integerp n)
		  (integerp k)
		  (>= x 0)
		  (>= k 0)
		  (> n k))
	     (equal (bitn x k)
		    (rem (fl (+ (* (expt 2 (- n k)) (fl (/ x (expt 2 n))))
				(/ (rem x (expt 2 n))
				   (expt 2 k))))
			 2)))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable a15)
                   ;; order switched below for Version  2.7 fertilization
		   :use ((:instance expt- (a n) (b k))
			 (:instance bit-rem-1))))))



(local
 (defthm bit-rem-3
   (implies (and (integerp x)
                 (integerp n)
                 (integerp k)
                 (>= x 0)
                 (>= k 0)
                 (>= n 0)
                 (> n k))
            (equal (rem (fl (+ (* (expt 2 (- n k)) (fl (/ x (expt 2 n))))
                               (/ (rem x (expt 2 n))
                                  (expt 2 k))))
                        2)
                   (rem (+ (* (expt 2 (- n k)) (fl (/ x (expt 2 n))))
                           (fl	(/ (rem x (expt 2 n))
				   (expt 2 k))))
                        2)))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable a10 fl+int-rewrite integerp-expt-type)
            :use ((:instance integerp-expt-type (n (- n k)))
                  (:instance fl+int-rewrite 
                             (x (/ (rem x (expt 2 n)) (expt 2 k)))
                             (n (* (expt 2 (- n k)) (fl (/ x (expt 2 n)))))))))))

(local
 (defthm bit-rem-4
   (implies (and (integerp x)
                 (integerp n)
                 (integerp k)
                 (>= x 0)
                 (>= k 0)
                 (> n k))
            (equal (bitn x k)
                   (rem (+ (* (expt 2 (- n k)) (fl (/ x (expt 2 n))))
                           (fl	(/ (rem x (expt 2 n))
				   (expt 2 k))))
                        2)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-rem-3)
			 (:instance bit-rem-2))))))

(local
 (defthm bit-rem-5
   (implies (and (integerp x)
                 (integerp n)
                 (integerp k)
                 (>= x 0)
                 (>= k 0)
                 (> n k))
            (equal (bitn x k)
                   (rem (+ (* 2 (expt 2 (1- (- n k))) (fl (/ x (expt 2 n))))
                           (fl	(/ (rem x (expt 2 n))
				   (expt 2 k))))
                        2)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-rem-4))))))

(local
 (defthm bit-rem-6
   (implies (and (integerp x)
                 (integerp n)
                 (integerp k)
                 (>= x 0)
                 (>= k 0)
                 (> n k))
            (>= (* (EXPT 2 (+ -1 N (* -1 K)))
                   (FL (* 1/2 X (/ (EXPT 2 (+ -1 N))))))
                0))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable expt-pos)
            :use ((:instance n<=fl-linear (n 0) (x (* 1/2 X (/ (EXPT 2 (+ -1 N))))))
                  (:instance expt-pos (x (1- (- n k)))))))))

(local
 (defthm bit-rem-7
   (implies (and (integerp x)
                 (integerp n)
                 (integerp k)
                 (>= x 0)
                 (>= k 0)
                 (> n k))
            (>= (FL (* (/ (EXPT 2 K))
                       (REM X (* 2 (EXPT 2 (+ -1 N))))))
                0))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable expt-pos)
            :use ((:instance n<=fl-linear (n 0) (x (* (/ (EXPT 2 K)) (REM X (* 2 (EXPT 2 (+ -1 N)))))))
                  (:instance expt-pos (x k))
                  (:instance rem>=0 (m x) (n (* 2 (EXPT 2 (+ -1 N)))))
                  (:instance expt-pos (x (1- n))))))))

(local
 (defthm bit-rem-8
   (implies (and (integerp x)
                 (integerp n)
                 (integerp k)
                 (>= x 0)
                 (>= k 0)
                 (> n k))
            (equal (bitn x k)
                   (rem (fl (/ (rem x (expt 2 n))
                               (expt 2 k)))
                        2)))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable integerp-expt-type)
            :use ((:instance bit-rem-5)
                         (:instance integerp-expt-type (n (1- (- n k))))
                         (:instance bit-rem-6)
                         (:instance bit-rem-7)
                         (:instance rem+ 
                                    (n 2)
                                    (m (fl (/ (rem x (expt 2 n))	(expt 2 k))))
                                    (a (* (expt 2 (1- (- n k))) (fl (/ x (expt 2 n)))))))))))

(defthm BIT-REM
  (implies (and (integerp x)
                (integerp n)
                (integerp k)
                (>= x 0)
                (>= k 0)
                (> n k))
           (equal (bitn x k)
                  (bitn (rem x (expt 2 n)) k)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit-rem-8)
			(:instance integerp-rem (m x) (n (expt 2 n)))
			(:instance rem>=0 (m x) (n (expt 2 n)))
			(:instance expt-pos (x n))
			(:instance bitn-def (x (rem x (expt 2 n))))))))

(defthm BIT-EXPO-A
  (implies (and (integerp x)
                (integerp n)
                (>= x 0)
                (>= n 0)
                (< x (expt 2 n)))
           (equal (bitn x n) 0))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-def (k n))
			(:instance rem< (m (fl (/ x (expt 2 n)))) (n 2))
			(:instance fl-unique (x (/ x (expt 2 n))) (n 0))))))

(defthm BIT-EXPO-B
  (implies (and (integerp x)
                (integerp n)
                (>= x 0)
                (>= n 0)
                (<= (expt 2 n) x)
                (< x (expt 2 (1+ n))))
           (equal (bitn x n) 1))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bitn-def (k n))
			(:instance rem< (m (fl (/ x (expt 2 n)))) (n 2))
			(:instance fl-unique (x (/ x (expt 2 n))) (n 1))))))

(local
 (defthm bit+-1
   (implies (and (integerp x)
                 (integerp m)
                 (integerp n)
                 (>= x 0)
                 (>= m n)
                 (>= n 0))
            (equal (bitn (+ x (expt 2 m)) n)
                   (rem (fl (+ (/ x (expt 2 n))
                               (expt 2 (- m n))))
                        2)))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable expt-pos a14 integerp-expt-type)
            :use ((:instance bitn-def (x (+ x (expt 2 m))) (k n))
                  (:instance integerp-expt-type (n m))
                  (:instance expt-pos (x m))
                  (:instance expt- (a m) (b n)))))))

(local
 (defthm bit+-2
   (implies (and (integerp x)
                 (integerp m)
                 (integerp n)
                 (>= x 0)
                 (>= m n)
                 (>= n 0))
            (equal (bitn (+ x (expt 2 m)) n)
                   (rem (+ (fl (/ x (expt 2 n)))
                           (expt 2 (- m n)))
                        2)))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable integerp-expt-type)
            :use ((:instance bit+-1)
                  (:instance integerp-expt-type (n (- m n)))
                  (:instance fl+int-rewrite (x (/ x (expt 2 n))) (n (expt 2 (- m n)))))))))



(defthm BIT+-A
  (implies (and (integerp x)
                (integerp n)
                (>= x 0)
                (>= n 0))
           (not (equal (bitn (+ x (expt 2 n)) n)
                       (bitn x n))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit+-2 (m n))
			(:instance rem+1-2 (x (fl (/ x (expt 2 n)))))
			(:instance bitn-def (k n))))))

(defthm BIT+-B
  (implies (and (integerp x)
                (integerp n)
                (integerp m)
                (>= x 0)
                (> m n)
                (>= n 0))
           (equal (bitn (+ x (expt 2 m)) n)
                  (bitn x n)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable expt integerp-expt-type)
           :use ((:instance bit+-2)
                 (:instance rem+
                            (m (fl (/ x (expt 2 n))))
                            (n 2)
                            (a (expt 2 (1- (- m n)))))
                 (:instance integerp-expt-type (n (1- (- m n))))
                 (:instance expo+ (m 1) (n (1- (- m n))))
                 (:instance bitn-def (k n))))))

(defun SHL (x s n)
  (rem (+ (* 2 x) s) (expt 2 n)))

(defun SHR (x s n)
  (+ (fl (/ x 2)) (* (expt 2 (1- n)) s)))

(defun CAT (x y n)
  (+ (* (expt 2 n) x) y))

(defun BITS (x i j)
  (fl (/ (rem x (expt 2 (1+ i))) (expt 2 j))))

(defthm bits-nat
    (implies (and (rationalp x); (integerp x)
                  (>= x 0)
		  (integerp i) (>= i 0)
		  (integerp j) (>= j 0))
	     (and (integerp (bits x i j))
		  (>= (bits x i j) 0)))
  :rule-classes ()
  :hints (("goal" :in-theory (enable bits)
           :use ((:instance rem>=0 (m x) (n (expt 2 (1+ i))))))))

(defthm bits<
    (implies (and (rationalp x) ;(integerp x)
                  (>= x 0)
		  (integerp i) (>= i 0)
		  (integerp j) (>= j 0))
	     (< (bits x i j) (expt 2 (- (1+ i) j))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable bits)
		  :use ((:instance rem<n (m x) (n (expt 2 (1+ i))))
                        (:instance expo+ (m (1+ i)) (n (- j)))
			(:instance *-strongly-monotonic
				   (x (expt 2 (- j)))
				   (y (rem x (expt 2 (1+ i))))
				   (y+ (expt 2 (1+ i))))
                        (:instance fl-def-linear (x (/ (rem x (expt 2 (1+ i))) (expt 2 j))))))))

(defthm REM-BITS
  (implies (and (integerp x)
                (>= x 0)
                (integerp y)
                (>= y 0)
                (integerp i)
                (>= i 0)
                (integerp j)
                (>= j 0)
                (= (rem x (expt 2 (1+ i))) (rem y (expt 2 (1+ i)))))
           (= (bits x i j) (bits y i j)))
  :rule-classes ())

(local
 (defthm bit-bits-1
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp n)
                 (>= n 0)
                 (integerp k)
                 (>= k 0)
                 (>= n k))
            (= (/ x (expt 2 k))
               (+ (* (expt 2 (- n k))
                     (fl (/ x (expt 2 n))))
                  (/ (rem x (expt 2 n))
                     (expt 2 k)))))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable a15)
            ;; order switched below for Version  2.7 fertilization
            :use ((:instance expt- (a n) (b k))
                  (:instance rem-fl (m x) (n (expt 2 n))))))))

(local
 (defthm bit-bits-2
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp n)
                 (>= n 0)
                 (integerp k)
                 (>= k 0)
                 (>= n k))
            (= (fl (+ (* (expt 2 (- n k))
                         (fl (/ x (expt 2 n))))
                      (/ (rem x (expt 2 n))
                         (expt 2 k))))
               (+ (* (expt 2 (- n k))
                     (fl (/ x (expt 2 n))))
                  (fl (/ (rem x (expt 2 n))
                         (expt 2 k))))))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable integerp-expt-type)
            :use ((:instance integerp-expt-type (n (- n k)))
                  (:instance fl+int-rewrite
                             (x (/ (rem x (expt 2 n)) (expt 2 k)))
                             (n (* (expt 2 (- n k)) (fl (/ x (expt 2 n)))))))))))

(local
 (defthm bit-bits-3
   (implies (= x y)
            (= (fl x) (fl y)))
   :rule-classes ()))

(local
 (defthm bit-bits-4
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp n)
                 (>= n 0)
                 (integerp k)
                 (>= k 0)
                 (>= n k))
            (= (fl (/ x (expt 2 k)))
               (+ (* (expt 2 (- n k))
                     (fl (/ x (expt 2 n))))
                  (fl (/ (rem x (expt 2 n))
                         (expt 2 k))))))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable a2 a9 a8)
            :use ((:instance bit-bits-1)
                  (:instance bit-bits-3 
                             (x (/ x (expt 2 k)))
                             (y (+ (* (expt 2 (- n k))
                                      (fl (/ x (expt 2 n))))
                                   (/ (rem x (expt 2 n))
                                      (expt 2 k)))))
                  (:instance bit-bits-2))))))

(local
 (defthm bit-bits-5
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k))
            (= (rem (fl (/ x (expt 2 k))) 
                    (expt 2 (- (1+ i) k)))
               (rem (+ (* (expt 2 (- (1+ i) k))
                          (fl (/ x (expt 2 (1+ i)))))
                       (fl (/ (rem x (expt 2 (1+ i)))
                              (expt 2 k))))
                    (expt 2 (- (1+ i) k)))))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-bits-4 (n (1+ i))))))))

(local
 (defthm bit-bits-6
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k))
            (integerp (expt 2 (+ 1 i (* -1 k)))))
   :rule-classes ()
   :hints (("goal" :use ((:instance integerp-expt-type (n (- (1+ i) k))))))))

(local
 (defthm bit-bits-7
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k))
            (>= (fl (* (/ (expt 2 k)) (rem x (* 2 (expt 2 i)))))
                0))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable expt-pos)
            :use ((:instance expt-pos (x k))
                  (:instance expt-pos (x i))
                  (:instance integerp-expt-type (n i))
                  (:instance rem>=0 (m x) (n (* 2 (EXPT 2 I))))
                  (:instance integerp-expt-type (n k))
                  (:instance n<=fl-linear (x (* (/ (EXPT 2 K)) (REM X (* 2 (EXPT 2 I))))) (n 0)))))))

(local
 (defthm bit-bits-8
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k))
            (= (rem (fl (/ x (expt 2 k))) 
                    (expt 2 (- (1+ i) k)))
               (rem (fl (/ (rem x (expt 2 (1+ i)))
                           (expt 2 k)))
                    (expt 2 (- (1+ i) k)))))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable integerp-expt-type)
            :use ((:instance bit-bits-5)
                  (:instance bit-bits-6)
                  (:instance bit-bits-7)
                  (:instance rem+ 
                             (m (fl (/ (rem x (expt 2 (1+ i))) (expt 2 k))))
                             (n (expt 2 (- (1+ i) k)))
                             (a (fl (/ x (expt 2 (1+ i)))))))))))

(local
 (defthm bit-bits-9
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k))
            (> (expt 2 (+ 1 i (* -1 k)))
               (* (/ (expt 2 k))
                  (rem x (* 2 (expt 2 i))))))
   :rule-classes ()
   :hints (("goal" :use ((:instance bit-bits-8)
                         (:instance bit-bits-6)
                         (:instance bit-bits-7)
                         (:instance rem<n (m x) (n (expt 2 (1+ i))))
                         (:instance expt- (a (1+ i)) (b k)))))))

(local
 (defthm bit-bits-10
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k))
            (> (expt 2 (+ 1 i (* -1 k)))
               (fl (* (/ (expt 2 k))
                      (rem x (* 2 (expt 2 i)))))))
   :rule-classes ()
   :hints (("goal" :in-theory (disable a9 a15)
            :use ((:instance bit-bits-9)
                  (:instance fl-def-linear (x (/ (rem x (expt 2 (1+ i))) (expt 2 k)))))))))

(local
 (defthm bit-bits-11
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k))
            (= (rem (fl (/ x (expt 2 k))) 
                    (expt 2 (- (1+ i) k)))
               (fl (/ (rem x (expt 2 (1+ i)))
                      (expt 2 k)))))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-bits-8)
                         (:instance bit-bits-6)
                         (:instance bit-bits-7)
                         (:instance bit-bits-10)
                         (:instance rem< 
                                    (m (fl (/ (rem x (expt 2 (1+ i))) (expt 2 k))))
                                    (n (expt 2 (- (1+ i) k)))))))))

(local
 (defthm bit-bits-12
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp i)
		  (>= i 0)
		  (integerp k)
		  (>= k 0)
		  (>= i k))
	     (= (bits (fl (/ x (expt 2 k)))
		      (- i k)
		      (- j k))
		(fl (/ (fl (/ (rem x (expt 2 (1+ i))) (expt 2 k)))
		       (expt 2 (- j k))))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit-bits-11))))))

(local
 (defthm bit-bits-13
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k)
                 (>= j k))
            (= (fl (/ (fl (/ (rem x (expt 2 (1+ i))) (expt 2 k)))
                      (expt 2 (- j k))))
               (fl (/ (rem x (expt 2 (1+ i)))
                      (expt 2 j)))))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable a15 bits integerp-expt-type)
            :use ((:instance expo+ (m k) (n (- j k)))
                  (:instance integerp-expt-type (n (- j k)))
                  (:instance fl/int-rewrite 
                             (x (/ (rem x (expt 2 (1+ i))) (expt 2 k)))
                             (n (expt 2 (- j k)))))))))

(local
 (defthm bit-bits-14
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (>= i k)
                 (>= j k))
            (= (bits (fl (/ x (expt 2 k)))
                     (- i k)
                     (- j k))
               (fl (/ (rem x (expt 2 (1+ i)))
                      (expt 2 j)))))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-bits-12)
                         (:instance bit-bits-13))))))

(defthm BIT-BITS-A
  (implies (and (integerp x)
                (>= x 0)
                (integerp i)
                (>= i 0)
                (integerp j)
                (>= j 0)
                (integerp k)
                (>= k 0)
                (>= i k)
                (>= j k))
           (= (bits (fl (/ x (expt 2 k)))
                    (- i k)
                    (- j k))
              (bits x i j)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit-bits-14)))))

(local
 (defthm bit-bits-15
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (>= i (+ j k)))
            (= (bitn (bits x i j) k)
               (rem (fl (/ (fl (/ (rem x (expt 2 (1+ i)))
                                  (expt 2 j)))
                           (expt 2 k)))
                    2)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bitn-def (x (bits x i j)))
                         (:instance bit-bits-7 (k j)))))))

(local
 (defthm bit-bits-16
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (>= i (+ j k)))
            (= (bitn (bits x i j) k)
               (rem (fl (/ (rem x (expt 2 (1+ i)))
                           (expt 2 (+ j k))))
                    2)))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable a15)
            :use ((:instance bit-bits-15)
                  (:instance fl/int-rewrite (x (/ (rem x (expt 2 (1+ i))) (expt 2 j))) (n (expt 2 k)))
                  (:instance expo+ (m j) (n k)))))))

(defthm BIT-BITS-B
  (implies (and (integerp x)
                (>= x 0)
                (integerp i)
                (>= i 0)
                (integerp j)
                (>= j 0)
                (integerp k)
                (>= k 0)
                (>= i (+ j k)))
           (= (bitn (bits x i j) k)
              (bitn x (+ j k))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit-bits-16)
			(:instance rem>=0 (m x) (n (expt 2 (1+ i))))
			(:instance bitn-def (x (rem x (expt 2 (1+ i)))) (k (+ j k)))
			(:instance bit-rem (n (1+ i)) (k (+ j k)))))))

(local
 (defthm bit-bits-17
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (>= i (+ j k)))
            (= (bits x i j)
               (rem (fl (/ x (expt 2 j))) (expt 2 (- (1+ i) j)))))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable integerp-rem)
            :use ((:instance bit-bits-a (k j))
                  (:instance integerp-expt-type (n (- (1+ i) j)))
                  (:instance integerp-rem (m (FL (/ x (EXPT 2 J)))) (n (EXPT 2 (- (1+ I) j)))))))))

(local
 (defthm bit-bits-18
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (>= i (+ j k)))
            (= (bits (bits x i j) k l)
               (fl (/ (rem (rem (fl (/ x (expt 2 j))) (expt 2 (- (1+ i) j)))
                           (expt 2 (1+ k)))
                      (expt 2 l)))))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-bits-17))))))



(local
 (defthm bit-bits-19
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (>= i (+ j k)))
            (= (bits (bits x i j) k l)
               (fl (/ (rem (fl (/ x (expt 2 j)))
                           (expt 2 (1+ k)))
                      (expt 2 l)))))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-bits-18)
                         (:instance rem-rem 
                                    (x (fl (/ x (expt 2 j))))
                                    (a (- (1+ i) j))
                                    (b (1+ k))))))))

(local
 (defthm bit-bits-20
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp i)
                 (>= i 0)
                 (integerp j)
                 (>= j 0)
                 (integerp k)
                 (>= k 0)
                 (integerp l)
                 (>= l 0)
                 (>= i (+ j k)))
            (= (bits (bits x i j) k l)
               (bits (fl (/ x (expt 2 j))) k l)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit-bits-19))))))

(defthm BIT-BITS-C
  (implies (and (integerp x)
                (>= x 0)
                (integerp i)
                (>= i 0)
                (integerp j)
                (>= j 0)
                (integerp k)
                (>= k 0)
                (integerp l)
                (>= l 0)
                (>= i (+ j k)))
           (= (bits (bits x i j) k l)
              (bits x (+ k j) (+ l j))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance bit-bits-20)
			(:instance bit-bits-a (k j) (i (+ j k)) (j (+ j
                                                                      l)))))))
(defthm bits-reduce
  (implies (and (integerp x)
                (<= 0 x)
                (integerp j)
                (>= j 0)
                (<= x (expt 2 j)))
           (equal (bits x j 0) x)))
