//This file is part of AcetoneISO. Copyright 2006,2007,2008,2009 Fabrizio Di Marco and Marco Di Antonio (acetoneiso@gmail.com)
//
//    AcetoneISO is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, either version 3 of the License, or
//    (at your option) any later version.
//
//    AcetoneISO is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with AcetoneISO.  If not, see <http://www.gnu.org/licenses/>.
 


 void acetoneiso::setdevices()
{
/*creo un file per inserirci le info riguardo l'udi. il path e le velocità le calcolerò da quest'ultimo*/
QString devicesInfo( QDir::temp().path() + "/acetoneiso/devicesInfo" );
QFile devicesInfo_file( devicesInfo );
/*apro il file in scrittura e in modalità testo*/
if (!devicesInfo_file.open(QIODevice::WriteOnly | QIODevice::Text))
return;
QTextStream out( &devicesInfo_file );
/*creo la connessione dbus a hal*/
QDBusConnection conn = QDBusConnection::systemBus();
QDBusInterface hal("org.freedesktop.Hal", 
                                 "/org/freedesktop/Hal/Manager", 
                                 "org.freedesktop.Hal.Manager", 
                                 conn);
/*cerco tutti i dispositivi storage.cdrom con hal via dbus*/
QDBusMessage msg = hal.call( "FindDeviceByCapability", "storage.cdrom");

QList<QVariant> devices = msg.arguments(); 
/*per ogni udi (dispositivo cdrom) che trovo, ricavo vendor, model, velocità e path*/
foreach (QVariant name, devices) 
		{ 
		  QString cdrom = name.toStringList()[0]; 
		  qDebug() << "Found device: " << cdrom; 
		  QString s; // udi del supporto ottico che andrò a calcolare più sotto.
		  QString media_type; //tipo di supporto, cd, dvd-r, dvd ecc...
		  QString is_media_empty;
		  QString is_appendable; //multisessione
		  QString capacity_string; //capacità del disco.
		  
		  QDBusInterface device("org.freedesktop.Hal", cdrom, "org.freedesktop.Hal.Device", conn);
		  /*ottengo il nome del vendor del cdrom*/
		  msg = device.call("GetProperty", "storage.vendor");
		  QVariant var = msg.arguments()[0]; 
		  QString vendor = var.toStringList()[0];
		  qDebug() << "VENDOR" << vendor;
		  /*ottengo il nome del modello del cdrom*/
		  msg = device.call("GetProperty", "storage.model");
		  QVariant var2 = msg.arguments()[0]; 
		  QString model = var2.toStringList()[0];
		  qDebug() << "MODEL" << model;
		  /*aggiungo il nome del device nella combobox*/
		  comboBox_devices->addItem( vendor.append( "\t" + model ) );
		  /*ottengo il path del dispositivo cdrom*/
		  msg = device.call("GetProperty", "block.device");
		  QVariant var3 = msg.arguments()[0]; 
		  QString path = var3.toStringList()[0];
		  qDebug() << "PATH" << path;
		  /*scopro se ho un cd o dvd dentro il device*/
		  msg = device.call("GetProperty", "storage.removable.media_available");
		  QVariant var5 = msg.arguments()[0];
		  bool opticDev = var5.toBool();
		  if( opticDev ) {
		  qDebug() << "MEDIA PRESENT" << "true";
		  /*cerco l'udi del supporto ottico*/
		  findmedia.setReadChannel(QProcess::StandardOutput);
		  findmedia.start("hal-find-by-property", QStringList() << "--key" << "info.parent" << "--string" << cdrom );
			if (!findmedia.waitForFinished()){
        		qDebug() << "FINDMEDIA ERROR:" << findmedia.errorString();
			}
    			else{
			QByteArray ba = findmedia.readAll();
			ba.chop(1);   // tolgo l'ultimo carattere che nel qbytearray di default è la new line...
			s = ( ba );
			}
		  qDebug() << "UDI SUPPORTO OTTICO: " << s;
		  /*cerco il tipo di supporto*/
		  mediaType.setReadChannel(QProcess::StandardOutput);
		  mediaType.start("hal-get-property", QStringList() << "--key" << "volume.disc.type" << "--udi" << s  );
			if (!mediaType.waitForFinished()){
        		qDebug() << "FINDMEDIA ERROR:" << mediaType.errorString();
			}
    			else{
			QByteArray ba = mediaType.readAll();
			ba.chop(1);   // tolgo l'ultimo carattere che nel qbytearray di default è la new line...
			media_type = ( ba );
			}
		  qDebug() << "TIPO DI SUPPORTO: " << media_type;
		  
		  /*scopriamo se il supporto ottico è pieno o vuoto*/
		  isMediaEmpty.setReadChannel(QProcess::StandardOutput);
		  isMediaEmpty.start("hal-get-property", QStringList() << "--key" << "volume.disc.is_blank" << "--udi" << s  );
			if (!isMediaEmpty.waitForFinished()){
        		qDebug() << "isMediaEmpty ERROR:" << isMediaEmpty.errorString();
			}
    			else{
			QByteArray ba = isMediaEmpty.readAll();
			ba.chop(1);   // tolgo l'ultimo carattere che nel qbytearray di default è la new line...
			is_media_empty = ( ba );
			}
		  qDebug() << "STATO SUPPORTO: " << is_media_empty;
		  
		  /*è multisessione?*/
		  isAppendable.setReadChannel(QProcess::StandardOutput);
		  isAppendable.start("hal-get-property", QStringList() << "--key" << "volume.disc.is_appendable" << "--udi" << s  );
		  if (!isAppendable.waitForFinished()) {
		     qDebug() << "isAppendable ERROR:" << isAppendable.errorString();
		     }
    			else {
			QByteArray ba = isAppendable.readAll();
			ba.chop(1);   // tolgo l'ultimo carattere che nel qbytearray di default è la new line...
			is_appendable = ( ba );
			}
		  qDebug() << "MULTISESSIONE?: " << is_appendable;
		  
		  /*capacità del disco*/
		  capacity.setReadChannel(QProcess::StandardOutput);
		  capacity.start("hal-get-property", QStringList() << "--key" << "volume.disc.capacity" << "--udi" << s  );
		  if (!capacity.waitForFinished()) {
		     qDebug() << "Capacity ERROR:" << capacity.errorString();
		     }
    			else {
			QByteArray ba = capacity.readAll();
			ba.chop(1);   // tolgo l'ultimo carattere che nel qbytearray di default è la new line...
			capacity_string = ( ba );
			}
		  qDebug() << "CAPACITA': " << capacity_string;
		  
		  
/*DA QUI INIZIANO I VARI CASI*/
		  if( is_media_empty == "true" )  {   //caso che il media è vuoto
			//TODO:caso che il supporto è vuoto.
			label->setText( media_type + tr("   Capacity: ") + capacity_string ) ;
			/*ottengo le velocità supportate dal  dispositivo cdrom*/
			msg = device.call("GetProperty", "storage.cdrom.write_speeds");
			QVariant var4 = msg.arguments()[0]; 
			QStringList speeds = var4.toStringList();
			QStringList speedsXlist;
			foreach( QString str, speeds )
			{	
				int velocita = str.toInt();
				int velocitaX = velocita / 1385; //per il dvd 1385=1x
				QString speedX( QString::number( velocitaX ) );
				//qDebug() << "VELOCITÀ X" << speedX ;
				speedsXlist.append( speedX + "x" );
		     }
		      speedsFile( speedsXlist );
		      /*inserisco nel file devicesInfo le informazioni che mi servono*/
		      out << path << "\n";
		      //comboBox->addItems( speeds );
		      setSpeedsCombo();
		      }//FINE OTTENGO VELOCITÀ.
		   else   {
		      //TODO:caso che il supporto non è vuoto.
			//VEDIAMO SE E' MULTISESSIONE
			if(is_appendable == "true" ) {
			   label->setText( media_type + tr("   Capacity: ") + capacity_string + tr(" used")) ;
			/*ottengo le velocità supportate dal  dispositivo cdrom*/
			   msg = device.call("GetProperty", "storage.cdrom.write_speeds");
			   QVariant var4 = msg.arguments()[0]; 
			   QStringList speeds = var4.toStringList();
			   QStringList speedsXlist;
			   foreach( QString str, speeds )
			   {	
				int velocita = str.toInt();
				int velocitaX = velocita / 1385; //per il dvd 1385=1x
				QString speedX( QString::number( velocitaX ) );
				//qDebug() << "VELOCITÀ X" << speedX ;
				speedsXlist.append( speedX + "x" );
			    }
		            speedsFile( speedsXlist );
		         /*inserisco nel file devicesInfo le informazioni che mi servono*/
		            out << path << "\n";
		            //comboBox->addItems( speeds );
		            setSpeedsCombo();
		         }//FINE OTTENGO VELOCITÀ.
			else {
			//il cd/dvd non e' multisessione
			//Ora voglio sapere se e' un dvd riscribile
			 if( media_type == "dvd_plus_rw" ) {
			    label->setText( media_type + tr("   Capacity: ") + capacity_string ) ;
			/*ottengo le velocità supportate dal  dispositivo cdrom*/
			    msg = device.call("GetProperty", "storage.cdrom.write_speeds");
			   QVariant var4 = msg.arguments()[0]; 
			   QStringList speeds = var4.toStringList();
			   QStringList speedsXlist;
			   foreach( QString str, speeds )
			   {	
				int velocita = str.toInt();
				int velocitaX = velocita / 1385; //per il dvd 1385=1x
				QString speedX( QString::number( velocitaX ) );
				//qDebug() << "VELOCITÀ X" << speedX ;
				speedsXlist.append( speedX + "x" );
		           }
		           speedsFile( speedsXlist );
		      /*inserisco nel file devicesInfo le informazioni che mi servono*/
		           out << path << "\n";
		           //comboBox->addItems( speeds );
		           setSpeedsCombo();
		        }//FINE OTTENGO VELOCITÀ.
			 else {
			 //essendo un cd/dvd NON vuoto, non multisessione e NON dvd_plus_rw, interrompo combobox e bottone burn now
			  comboBox->clear();
		          comboBox->addItem("---");
			  comboBox->setDisabled( true );
		          pushButton_burn->setDisabled( true );
			 }
			}
		      }
/*QUI FINISCONO I CASI*/


		 
		 
		}
	       else { //non trovo nessun supporto ottico.
	             label->setText( tr("Insert an empty media") );
		     qDebug() << "MEDIA PRESENT" << "falso";
		     comboBox->clear();
		     comboBox->addItem("---");
		     comboBox->setDisabled( true );
		     pushButton_burn->setDisabled( true );
		    }
               }
}

void acetoneiso::setSpeedsCombo()
{
comboBox->clear();
QString speedsInfo( QDir::temp().path() + "/acetoneiso/speedsInfo" );
QFile speedsInfo_file( speedsInfo );

/*ottengo l'indice dell'item corrente nel comboBox_devices*/
int currentDevice = comboBox_devices->currentIndex() + 1;
qDebug() << "CURRENT INDEX" << currentDevice;
//ricaviamo le velocita dal file speedsInfo
speedsInfo_file.open( QIODevice::ReadOnly );   //apro il file in sola lettura
/*legge la riga n corrispondente al current item del file devicesInfo_file*/
QString speedstring = ( leggiRigo( currentDevice, &speedsInfo_file ) );
//QByteArray line = "";    
//for(int i = 0; i < currentDevice; i++)
//line = speedsInfo_file.readLine();
//QString speedstring( line );

//adesso trasformiamo la stringa speedstring in una qstringlist per popolare il combobox delle velocita
QStringList speedlist;
speedstring.chop(1); //con questo comando rimuovo il carattere "\n" che sembra essere alla fine della stringa e che mi crea uno spazio bianco nel combobox.
speedlist = speedstring.split(" ");
comboBox->addItems(speedlist);
qDebug() << "SPEEDLIST" <<  speedlist;
/*ora dall'udi posso ricavarmi tutte le info che voglio!*/

//comboBox->addItems( line );
}

void acetoneiso::speedsFile( QStringList strl )
{
QString speedsInfo( QDir::temp().path() + "/acetoneiso/speedsInfo" );
QFile speedsInfo_file( speedsInfo );

if (!speedsInfo_file.open(QIODevice::WriteOnly | QIODevice::Text))
return;
QTextStream out( &speedsInfo_file );
QString speedstring;
speedstring = strl.join (" ");
out << speedstring << "\n";
}



