/**
 * @author Johnny Willemsen  <jwillemsen@remedy.nl>
 *
 * $Id: DDS_State_Connector_T.h 89083 2010-02-19 12:53:28Z johnnyw $
 *
 * Wrapper facade for NDDS.
 */
#ifndef DDS_STATE_CONNECTOR_T_H_
#define DDS_STATE_CONNECTOR_T_H_

#include "dds4ccm/impl/ndds/DDS_TopicBase_Connector_T.h"
#include "dds4ccm/impl/ndds/DDS_Get_T.h"
#include "dds4ccm/impl/ndds/DDS_Listen_T.h"
#include "dds4ccm/impl/ndds/DDS_StateListen_T.h"
#include "dds4ccm/impl/ndds/DDS_Update_T.h"
#include "dds4ccm/impl/ndds/DDS_Read_T.h"

template <typename DDS_TYPE, typename CCM_TYPE, bool FIXED>
class DDS_State_Connector_T
  : public virtual DDS_TopicBase_Connector_T<DDS_TYPE, CCM_TYPE>
{
public:
  DDS_State_Connector_T (void);
  virtual ~DDS_State_Connector_T (void);

  virtual typename CCM_TYPE::updater_type::_ptr_type
  get_observable_data (void);

  virtual ::DDS::CCM_DataWriter_ptr
  get_observable_dds_entity (void);

  virtual typename CCM_TYPE::reader_type::_ptr_type
  get_passive_observer_data (void);

  virtual ::DDS::CCM_DataReader_ptr
  get_passive_observer_dds_entity (void);

  virtual typename CCM_TYPE::reader_type::_ptr_type
  get_pull_observer_data (void);

  virtual typename CCM_TYPE::getter_type::_ptr_type
  get_pull_observer_fresh_data (void);

  virtual ::DDS::CCM_DataReader_ptr
  get_pull_observer_dds_entity (void);

  virtual typename CCM_TYPE::reader_type::_ptr_type
  get_push_observer_data (void);

  virtual ::CCM_DDS::CCM_DataListenerControl_ptr
  get_push_observer_data_control (void);

  virtual ::DDS::CCM_DataReader_ptr
  get_push_observer_dds_entity (void);

  virtual typename CCM_TYPE::reader_type::_ptr_type
  get_push_state_observer_data (void);

  virtual ::CCM_DDS::CCM_StateListenerControl_ptr
  get_push_state_observer_data_control (void);

  virtual ::DDS::CCM_DataReader_ptr
  get_push_state_observer_dds_entity (void);

  virtual void configuration_complete (void);

  virtual void ccm_activate (void);
  virtual void ccm_passivate (void);
  virtual void ccm_remove (void);

private:
  /**
   * DDS_Update observable
   */
  //@{
  DDS_Update_T <DDS_TYPE, CCM_TYPE> observable_;
  //@}

  /**
   * DDS_Read passive_observer
   */
  //@{
  DDS_Read_T <DDS_TYPE, CCM_TYPE> passive_observer_;
  //@}

  /**
   * DDS_Get pull_observer
   */
  //@{
  DDS_Get_T <DDS_TYPE, CCM_TYPE, FIXED> pull_observer_;
  //@}

  /**
   * DDS_Listen push_observer
   */
  //@{
  DDS_Listen_T <DDS_TYPE, CCM_TYPE> push_observer_;
  //@}

  /**
   * DDS_StateListen push_state_observer
   */
  //@{
  DDS_StateListen_T <DDS_TYPE, CCM_TYPE> push_state_observer_;
  //@}
};

#include "dds4ccm/impl/ndds/DDS_State_Connector_T.cpp"

#endif /* DDS_STATE_CONNECTOR_T_H_ */
