// -*- C++ -*-

//=============================================================================
/**
 *  @file    Context_Impl_T.h
 *
 *  Context_Impl_T.h,v 1.1 2004/09/14 20:03:51 parsons Exp
 *
 *  This file contains the declaration of a mixin base class for
 *  the generated context class.
 *
 *  @author Jeff Parsons <j.parsons@vanderbilt.edu>
 */
//=============================================================================


#ifndef CIAO_CONTEXT_IMPL_T_H
#define CIAO_CONTEXT_IMPL_T_H

#include /**/ "ace/pre.h"

#include "Context_Impl_Base.h"
#include "tao/LocalObject.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

namespace CORBA
{
  class SystemException;
}

namespace SecurityLevel2
{
  class Credentials;
}

namespace Components
{
  typedef SecurityLevel2::Credentials Principal;
  typedef Principal *Principal_ptr;
  
  class IllegalState;
  
  namespace Transaction
  {
    class UserTransaction;
    typedef UserTransaction *UserTransaction_ptr;
  }
}

namespace CIAO
{
  class Session_Container;

  /**
   * @class Context_Impl
   *
   * @brief Mixin base class for generated context.
   *
   * This class implements operations and contains parameterized
   * members common to all generated servants.
   */
  template <typename BASE_CTX, 
            typename SVNT, 
            typename COMP, 
            typename COMP_VAR>
  class Context_Impl : public virtual BASE_CTX,
                       public virtual Context_Impl_Base,
                       public virtual TAO_Local_RefCounted_Object
  {
  public:
    Context_Impl (Components::CCMHome_ptr home,
                  Session_Container *c,
                  SVNT *sv);

    virtual ~Context_Impl (void);

    // Operations from ::Components::SessionContext.

    virtual CORBA::Object_ptr
    get_CCM_object (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
      ACE_THROW_SPEC ((CORBA::SystemException,
                       Components::IllegalState));
                       
  protected:
    SVNT *servant_;
    COMP_VAR component_;
  };
}

#if defined (ACE_TEMPLATES_REQUIRE_SOURCE)
#include "Context_Impl_T.cpp"
#endif /* ACE_TEMPLATES_REQUIRE_SOURCE */

#if defined (ACE_TEMPLATES_REQUIRE_PRAGMA)
#pragma implementation ("Context_Impl_T.cpp")
#endif /* ACE_TEMPLATES_REQUIRE_PRAGMA */

#include /**/ "ace/post.h"

#endif /* CIAO_CONTEXT_IMPL_T_H */
