// file      : CIDLC/ServantHeaderGenerator.hpp
// author    : Jeff Parsons <j.parsons@vanderbilt.edu>
// cvs-id    : ExecImplHeaderGenerator.hpp,v 1.1 2004/08/05 23:02:33 parsons Exp

#ifndef EXEC_IMPL_HEADER_GENERATOR_HPP
#define EXEC_IMPL_HEADER_GENERATOR_HPP

#include "CCF/CodeGenerationKit/CommandLine.hpp"

#include "CCF/CIDL/SemanticGraph.hpp"
#include "CCF/CIDL/Traversal.hpp"

using std::string;

class ExecImplHeaderEmitter
{
public:
  ExecImplHeaderEmitter (std::ostream& os_,
                         CommandLine const& cl,
                         string export_macro,
                         fs::path const& file);
                        
  virtual ~ExecImplHeaderEmitter () {}

  virtual void
  pre (CCF::CIDL::SemanticGraph::TranslationUnit& u);

  virtual void
  generate (CCF::CIDL::SemanticGraph::TranslationUnit& u);

  virtual void
  post (CCF::CIDL::SemanticGraph::TranslationUnit& u);

private:
  std::ostream& os;
  CommandLine const& cl_;
  string export_macro_;
  fs::path file_;
};


#endif // EXEC_IMPL_HEADER_GENERATOR_HPP

