/* -*- C++ -*- */
// IFR_macro.h,v 1.4 2003/10/28 18:34:23 bala Exp

#ifndef TAO_IFR_MACROS_H
#define TAO_IFR_MACROS_H

#include /**/ "ace/pre.h"
#include "ace/CORBA_macros.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "tao/ORB_Constants.h"

#define TAO_IFR_WRITE_GUARD \
  ACE_WRITE_GUARD_THROW_EX (ACE_Lock, \
                            monitor, \
                            this->repo_->lock (), \
                            CORBA::INTERNAL ( \
                              CORBA::SystemException::_tao_minor_code ( \
                                TAO_GUARD_FAILURE, \
                                0), \
                              CORBA::COMPLETED_NO)); \
  ACE_CHECK

#define TAO_IFR_WRITE_GUARD_RETURN(RETURN) \
  ACE_WRITE_GUARD_THROW_EX (ACE_Lock, \
                            monitor, \
                            this->repo_->lock (), \
                            CORBA::INTERNAL ( \
                              CORBA::SystemException::_tao_minor_code ( \
                                TAO_GUARD_FAILURE, \
                                0), \
                              CORBA::COMPLETED_NO)); \
  ACE_CHECK_RETURN (RETURN)

#define TAO_IFR_READ_GUARD_RETURN(RETURN) \
  ACE_READ_GUARD_THROW_EX (ACE_Lock, \
                           monitor, \
                           this->repo_->lock (), \
                           CORBA::INTERNAL ( \
                             CORBA::SystemException::_tao_minor_code ( \
                               TAO_GUARD_FAILURE, \
                               0), \
                             CORBA::COMPLETED_NO)); \
  ACE_CHECK_RETURN (RETURN)

#include /**/ "ace/post.h"

#endif /* TAO_IFR_MACROS_H */
