// file      : CCF/IDL2/SemanticGraph/Enum.hpp
// author    : Boris Kolpackov <boris@dre.vanderbilt.edu>
// cvs-id    : Enum.hpp,v 1.1 2003/12/23 16:03:44 boris Exp

#ifndef CCF_IDL2_SEMANTIC_GRAPH_ENUM_HPP
#define CCF_IDL2_SEMANTIC_GRAPH_ENUM_HPP

#include "CCF/IDL2/SemanticGraph/Elements.hpp"

namespace CCF
{
  namespace IDL2
  {
    namespace SemanticGraph
    {
      class Enum : public virtual Type
      {
      public:
        virtual bool
        complete () const
        {
          return true;
        }

        static Introspection::TypeInfo const&
        static_type_info ();

      protected:
        friend class Graph<Node, Edge>;

        Enum ()
        {
          type_info (static_type_info ());
        }
      };


      class Enumerator : public virtual Nameable, public virtual Instance
      {
      public:
        static Introspection::TypeInfo const&
        static_type_info ();

      protected:
        friend class Graph<Node, Edge>;

        Enumerator ()
        {
          type_info (static_type_info ());
        }
      };
    }
  }
}

#endif  // CCF_IDL2_SEMANTIC_GRAPH_ENUM_HPP
