// -*- C++ -*-

//=============================================================================
/**
 *  @file    OS_Log_Msg_Attributes.h
 *
 *  OS_Log_Msg_Attributes.h,v 4.5 2000/11/18 18:03:54 coryan Exp
 *
 *  @author Carlos O'Ryan
 */
//=============================================================================


#ifndef ACE_OS_LOG_MSG_ATTRIBUTES_H
#define ACE_OS_LOG_MSG_ATTRIBUTES_H
#include "ace/pre.h"

#include "ace/config-all.h"
#include "ace/streams.h"
#include /**/ <stdarg.h> // LynxOS requires this before stdio.h
#include /**/ <stdio.h>

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#if !defined (ACE_OSTREAM_TYPE)
# if defined (ACE_LACKS_IOSTREAM_TOTALLY)
#   define ACE_OSTREAM_TYPE FILE
# else  /* ! ACE_LACKS_IOSTREAM_TOTALLY */
#   define ACE_OSTREAM_TYPE ostream
# endif /* ! ACE_LACKS_IOSTREAM_TOTALLY */
#endif /* ! ACE_OSTREAM_TYPE */


#include "ace/OS_Export.h"

/// The attributes required by ACE_Log_Msg.
/**
 * When a new thread is created the TSS resources for the Log_Msg
 * class in the new thread may be inherited by the creator thread.
 * The base_attributes are encapsulated in this class to simplify their
 * manipulation and destruction.
 *
 * The contents of the class must be made available to the OS layer,
 * because they are part of the thread descriptor.
 */
class ACE_OS_Export ACE_OS_Log_Msg_Attributes
{
public:
  /// Constructor
  ACE_OS_Log_Msg_Attributes (void);

protected:
  friend class ACE_Log_Msg;

  /// Ostream where the new TSS Log_Msg will use.
  ACE_OSTREAM_TYPE *ostream_;

  /// Priority_mask to be used in new TSS Log_Msg.
  unsigned long priority_mask_;

  /// Are we allowing tracing in this thread?
  int tracing_enabled_;

  /// Indicates whether we should restart system calls that are
  /// interrupted.
  int restart_;

  /// Depth of the nesting for printing traces.
  int trace_depth_;

#   if defined (ACE_HAS_WIN32_STRUCTURAL_EXCEPTIONS)
  /// Structured exception handling Callbacks, only used under Win32
  ACE_SEH_EXCEPT_HANDLER seh_except_selector_;
  ACE_SEH_EXCEPT_HANDLER seh_except_handler_;
#   endif /* ACE_HAS_WIN32_STRUCTURAL_EXCEPTIONS */
};

# if defined (ACE_HAS_INLINED_OSCALLS)
#   if defined (ACE_INLINE)
#     undef ACE_INLINE
#   endif /* ACE_INLINE */
#   define ACE_INLINE inline
#   include "ace/OS_Log_Msg_Attributes.inl"
# endif /* ACE_HAS_INLINED_OSCALLS */

#include "ace/post.h"
#endif /* ACE_OS_LOG_MSG_ATTRIBUTES_H */
