!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_rhoij0
!! NAME
!! calc_rhoij0
!! 
!! FUNCTION
!! Compute initial values (atomic initialization) of rhoij0
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!! 
!! INPUTS
!!  pawdata
!!    %rad_(big_meshsz)= rad(:) + AA where rad(i)=AA*(exp[BB*(i-1)]-1)
!!  pawarray
!!    %occ_(2,nref,nval)= Valence states occupancies deduce from reference
!!                        energies and densities considerations
!!  pshead
!!    %basis_size= Number of elements for the paw nl basis
!!    %orbitals(basis_size)= Quantum number l for each basis function
!!    %sph_meshsz= Dimension of radial mesh for spheres
!!
!! OUTPUT
!!  pawps
!!    %rhoij0= Atomic initialization of rhoij
!!
!! PARENTS
!!      uspp2abinit
!!
!! CHILDREN
!!      ctrap
!!
!! SOURCE

 subroutine calc_rhoij0(pawarray,pawdata,pawps,pshead)

 use defs_basis
 use defs_pawps

 implicit none

!Arguments ---------------------------------------------
!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawps_type)    :: pawps
 type(pshead_type)   :: pshead

!Local variables ---------------------------------------
 integer :: ib,ilmn,ilmn0,ll2
 real(dp), allocatable :: ff(:),mean_occ(:)


! *************************************************************************

 allocate(mean_occ(pshead%basis_size))

!Compute mean value of occupancie for each partial wave
 allocate(ff(pshead%sph_meshsz))
 do ib=1,pshead%basis_size
  ff(1:pshead%sph_meshsz)=pawarray%occ_(1:pshead%sph_meshsz,ib) &
&                        *pawdata%rad_(1:pshead%sph_meshsz)
  call ctrap(pshead%sph_meshsz,ff,pshead%log_step,mean_occ(ib))
  mean_occ(ib)=mean_occ(ib)/(pawdata%rad(pshead%sph_meshsz)-pawdata%rad(1))
  if (abs(mean_occ(ib)-nint(mean_occ(ib)))<tol8) mean_occ(ib)=nint(mean_occ(ib))
 enddo
 deallocate(ff)

!Store occupancies in Rhoij0
 pawps%rhoij0=zero;ilmn0=0
 do ib=1,pshead%basis_size
  ll2=2*pshead%orbitals(ib)+1
  do ilmn=ilmn0+1,ilmn0+ll2
   pawps%rhoij0(ilmn*(ilmn+1)/2)=mean_occ(ib)/dble(ll2)
  enddo
  ilmn0=ilmn0+ll2
 enddo

 deallocate(mean_occ)

 end subroutine
!!***
