# $Id: defaults.tcl,v 1.9 1996/09/02 10:51:12 aml Exp $
#
#

#
# Includes all defaults and temporary values
#

proc defWidthInCells {} {
    return [DefWidthInCells]
}

proc defHeightInCells {} {
    return [DefHeightInCells]
}

proc defSheetWidth {} {
    return [DefSheetWidth]
}

proc defSheetHeight {} {
    return [DefSheetHeight]
}

proc defCellHeight {} {
    return [DefCellHeight]
}

proc defCellWidth {} {
    return [DefCellWidth]
}

proc defWidth {} {
    return [expr [defSheetWidth]*[defCellWidth]]
}

proc defHeight {} {
    return [expr [defSheetHeight]*[defCellHeight]]
}

proc defDispWidth {} {
    return [expr [defWidthInCells]*[defCellWidth]+1]
}

proc defDispHeight {} {
    return [expr [defHeightInCells]*[defCellHeight]+1]
}

proc cellCol {sheet x} {
    global activeSheet
    return [CellCol $activeSheet $x]
#    return [expr int($x/[defCellWidth])]
}

proc cellRow {sheet y} {
    global activeSheet
    return [CellRow $activeSheet $y]
    return [expr int($y/[defCellHeight])]
}

proc colOrigin {col} {
    global activeSheet
    return [ColOrigin $activeSheet $col]
#    return [expr [defCellWidth]*($col)]
}

proc rowOrigin {row} {
    global activeSheet
    return [RowOrigin $activeSheet $row]
}

proc colCenter {col} {
    return [expr ([colOrigin $col]+[colOrigin [expr $col+1]])/2]
}

proc rowCenter {row} {
    return [expr ([rowOrigin $row]+[rowOrigin [expr $row+1]])/2]
}

set warningFont "-adobe-times-*-r-*-*-24-*"
set titleFont "-adobe-times-*-r-*-*-18-*"
set entryFont "-adobe-helvetica-*-r-*-*-12-*"

#
# $Log: defaults.tcl,v $
# Revision 1.9  1996/09/02  10:51:12  aml
# Cell fonts created, loaded and saved.
# Row height created.
#
# Revision 1.8  1996/08/24  10:15:59  aml
# Scroll almost fixed. We are missing scroll steps.
# Several sheets work again, but need to be fixed right.
#
# Revision 1.7  1996/08/23  16:13:33  aml
# Top window resizing now works well.
# Range selection now uses a filled rectangle with overall good results.
# Intermediate version, does not work well.
#
# Revision 1.6  1996/04/27 11:12:32  aml
# Inserted check and delete button.
# Font selection widget created.
# Fixed bug canvas_information destructor.
#
# Revision 1.5  1996/02/19  15:47:33  aml
# Fixed abnormality with mouse click.
# Variable width columns implemented, but not yet saved.
# Labels are now a lex element, fixing some aberrant behavior that existed.
#
# Revision 1.4  1996/01/10  18:53:39  aml
# Fixed limited integer range of cells.
# Fixed incorrect code in spreadsheet type.
# Users interface improved. Cursors and mouse clicks
# now work in the most basic modes.
#
# Revision 1.3  1996/01/03  23:07:12  aml
# Absolute and relative references to cells introduced.
# They are parsed and reverse parsed, not yet evaluated.
#
# Revision 1.2  1995/12/14  12:13:01  aml
# Version 0.4.2
#
# Revision 1.1  1995/11/08  22:09:39  aml
# Initial revision
#
#