/* ------------------------------------------------------------------------
 * $Id: RuleSet.cc,v 1.2 2001/06/25 12:28:36 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-12 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- Zorn Includes
#include "AST.hh"
#include "ASTVisitor.hh"
#include "RuleSet.hh"

Zorn::RuleSet *Zorn::RuleSet::_instance = 0;

// -- Code Segment

Zorn::RuleSet::RuleSet()
{
    // empty 
}

Zorn::RuleSet::~RuleSet()
{
    deleteAll(_rules);
    deleteAll(_inits);
}

void Zorn::RuleSet::addRule(AST *rule)
{
    // We may have encountered a parse error, so the rule is invalid
    if (rule == 0) return;
    
    // Add the rule to the rule list
    _rules.push_back(rule);
}

void Zorn::RuleSet::addInit(AST *init)
{
    // We may have encountered a parse error, so the init is invalid
    if (init == 0) return;
    
    // Add the init to the init list
    _inits.push_back(init);
}

void Zorn::RuleSet::visitAll(const std::vector<AST *> &vs, ASTVisitor *visitor)
{
    // Visit all AST nodes
    for (std::vector<AST *>::const_iterator i = vs.begin(); i != vs.end();
	 i++) {

	// Initialize the visitor
	visitor->beginVisit();
	
	// Perform the traversal
	(*i)->accept(visitor);
	
	// Cleanup the visitor
	visitor->endVisit();
    }
}

void Zorn::RuleSet::visitAllRules(ASTVisitor *visitor)
{
    // Visit all rules
    visitAll(_rules, visitor);
}

void Zorn::RuleSet::visitAllInits(ASTVisitor *visitor)
{
    // Visit all inits
    visitAll(_inits, visitor);
}

void Zorn::RuleSet::deleteAll(std::vector<AST *> &vs)
{
    // Delete all nodes in the list 
    for (std::vector<AST *>::iterator i = vs.begin(); i != vs.end(); i++)
	delete *i;
    vs.clear();
}
