/* ------------------------------------------------------------------------
 * $Id: PrimitiveImpl.cc,v 1.1 2001/08/01 15:09:00 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-01 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Celsius/Guard.hh"
#include "Polhem/PrimitiveImpl.hh"

using namespace Nobel;

PrimitiveImpl::PrimitiveImpl(TriangleMesh *mesh)
    : _mesh(mesh)
{
    // empty
}

PrimitiveImpl::~PrimitiveImpl()
{
    // Delete the triangle mesh
    delete _mesh;
}

TriangleMesh *PrimitiveImpl::getMesh()
{
    // Create a new triangle mesh and copy contents from the existing mesh
    Guard<Mutex> guard(_mutex);
    TriangleMesh *mesh_ptr = new TriangleMesh(*_mesh);
    return mesh_ptr;    
}
