/* ------------------------------------------------------------------------
 * $Id: NodeImpl.cc,v 1.21 2001/08/21 21:37:40 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-11 by Niklas Elmqvist.
 *
 * Copyright (c) 2000, 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Celsius/Mutex.hh"
#include "Celsius/Guard.hh"
#include "Celsius/Logger.hh"
#include "Nobel/Volume.hh"
#include "Polhem/VisitorImpl.hh"
#include "Polhem/EmitterImpl.hh"
#include "Polhem/LogGroup.hh"
#include "Polhem/NodeImpl.hh"

using namespace Nobel;

// -- Code Segment

NodeImpl::NodeImpl()
{
    // empty
}

Transform_ptr NodeImpl::transformation()
{
    Guard<Mutex> guard(_mutex);
    return Transform::_nil();
}

void NodeImpl::traverse(Visitor_ptr v)
{
    v->visit(Node_var(_this()));
}

void NodeImpl::receive(const Nobel::Event& e)
{
    // Try to handle the event internally
    if (handleNodeEvents(e) == false) {

	// Can't handle it, propagate the event upwards
	emit(e);
    }
}

Volume_ptr NodeImpl::getBoundingVolume()
{
    Guard<Mutex> guard(_mutex);    
    return Volume::_nil();
}

bool NodeImpl::handleNodeEvents(const Nobel::Event &e)
{
    // See if we can handle the event
    switch (e.type) {

    // Child node has a changed bounding volume
    case BoundingVolumeChanged:

	Logger::log(LogGroup::Event) << "BoundingVolumeChanged received."
				     << std::endl;
	
	// Recompute our bounding volume
	recomputeBoundingVolume();
	return true;

    default: break;
    }
    
    return false;
}
