/* ------------------------------------------------------------------------
 * Time.cc
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-08 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- System Includes
#include <sys/time.h>
#include <unistd.h>
#include <ctime>
#include <cmath>

// -- 3Dwm Includes
#include "Exception.hh"
#include "Time.hh"

// -- Static Instances

double Time::time()
{
    timeval tv;
    
    // Query for the time
    if (gettimeofday(&tv, 0) == -1)
	throw Exception("gettimeofday()");
    
    return tv.tv_sec + tv.tv_usec / 1000.0;
}

void Time::sleep(double time)
{
    timeval tv;
    
    // Build the timeval struct's contents
    tv.tv_sec = (long) floor(time);
    tv.tv_usec = (long) (time - floor(time)) * 1e6;

    // Sleep using select() (most portable)
    if (select(0, 0, 0, 0, &tv) == -1)
	throw Exception("select()");
}
