/* ------------------------------------------------------------------------
 * $Id: VolumeImpl.hh,v 1.2 2001/07/13 12:50:18 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-05-29 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _VolumeImpl_hh_
#define _VolumeImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Volume.hh"

class VolumeImpl : public virtual POA_Nobel::Volume,
		   public virtual PortableServer::RefCountServantBase {
    
public:

    /**
     * Constructor.
     **/
    VolumeImpl();

    /**
     * Copy constructor.
     **/
    VolumeImpl(const VolumeImpl &v);

    /**
     * Destructor.
     **/
    virtual ~VolumeImpl();
    
    // IDL functions
    virtual CORBA::Boolean inside(const Nobel::Vertex3D &v);
    virtual void getBounds(Nobel::Vertex3D &min, Nobel::Vertex3D &max);
    virtual void merge(Nobel::Volume_ptr v);
    
    /**
     * Set new vertex boundaries for the bounding volume.
     *
     * @param min minimum vertex bound.
     * @param max maximum vertex bound.
     **/
    virtual void setBounds(Nobel::Vertex3D &min, Nobel::Vertex3D &max);

    /**
     * Assignment operator. 
     **/
    virtual VolumeImpl &operator = (const VolumeImpl &v);

    /**
     * Equality operator.
     **/
    virtual bool operator == (const VolumeImpl &v);
    
    /**
     * Inequality operator.
     **/
    virtual bool operator != (const VolumeImpl &v);
    
protected:

    // Vertex boundaries
    Nobel::Vertex3D _min, _max;
};

#endif /* VolumeImpl.hh */
