/* ------------------------------------------------------------------------
 * $Id: SystemCommand.hh,v 1.6 2001/08/28 13:18:50 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-15 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _SystemCommand_hh_
#define _SystemCommand_hh_

// -- System Includes
#include <map>

// -- 3Dwm Includes
#include "Zorn/FunctionObject.hh"

// -- Forward Declarations
class SceneManager;

// -- Class Declarations

/**
 * 3Dwm display server system command mapping for Zorn.
 **/
class SystemCommand : public Zorn::FunctionObject {
public:
    
    /**
     * Constructor.
     **/
    SystemCommand(SceneManager *smanager);

    /**
     * Destructor.
     **/
    virtual ~SystemCommand();
    
    /**
     * Execute a Zorn system command function.
     *
     * @param id name of Zorn function to execute.
     * @param vs value list to pass to the function.
     * @param store memory store to use for memory access.
     * @return the return value of the Zorn function.
     **/
    Zorn::Value execute(const std::string &id,
			const Zorn::ValueList &vs,
			Zorn::Store *store);
    
    /**
     * Retrieve the parameter count of a Zorn function with a
     * given name in the function object.
     *
     * @param id name of Zorn function to query.
     * @return number of parameters to pass to the function.
     **/
    virtual int getParamCount(const std::string &id);
    
    /**
     * Retrieve the names of all the Zorn functions implemented by
     * this function object.
     *
     * @return a vector of Zorn function names.
     **/
    virtual std::vector<std::string> getFunctionNames() const;

    /**
     * Zorn function type definition.
     **/
    typedef Zorn::Value (SystemCommand::*FunctionMethod)
	(const Zorn::ValueList &vs, Zorn::Store *store);
    
private:
    
    // -- 3Dwm Zorn functions
    Zorn::Value quit(const Zorn::ValueList &vs, Zorn::Store *store);
    Zorn::Value viewOrbit(const Zorn::ValueList &vs, Zorn::Store *store);
    Zorn::Value viewTrack(const Zorn::ValueList &vs, Zorn::Store *store);
    Zorn::Value viewDolly(const Zorn::ValueList &vs, Zorn::Store *store);
    Zorn::Value viewZoom(const Zorn::ValueList &vs, Zorn::Store *store);
    Zorn::Value keyEvent(const Zorn::ValueList &vs, Zorn::Store *store);
    Zorn::Value mouseButtonEvent(const Zorn::ValueList &vs,Zorn::Store *store);
    Zorn::Value mouseMoveEvent(const Zorn::ValueList &vs, Zorn::Store *store);

    std::map<std::string, FunctionMethod> _functions;
    std::map<std::string, int> _paramCount;
    
    SceneManager *_smanager;
};

#endif /* SystemCommand.hh */
