/* ------------------------------------------------------------------------
 * $Id: ServerImpl.hh,v 1.9 2001/06/27 12:48:55 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-08 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _ServerImpl_hh_
#define _ServerImpl_hh_

// -- System Includes
#include <list>

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Server.hh"
#include "Nobel/Client.hh"
#include "Celsius/Runnable.hh"

// -- Forward Declarations
class Mutex;
class SceneManager;
class ServerHandleImpl;

// -- Class Declarations

class ServerImpl : public Runnable,
                   public virtual POA_Nobel::Server,
		   public virtual PortableServer::RefCountServantBase {
    
public:

    /**
     * Constructor.
     **/ 
    ServerImpl(SceneManager *smanager);
    
    /**
     * Destructor.
     **/
    ~ServerImpl();
        
    // IDL functions
    virtual Nobel::ServerHandle_ptr connect(const char *name,
					    Nobel::ClientHandle_ptr c);
    
    /**
     * Enter the server main loop. This will take care of new client
     * connections and ping them intermittently.
     **/ 
    void run();

    /**
     * Ping all clients and destroy those that have crashed (no
     * response).
     **/
    void ping();

    /**
     * Destroy the client that is associated with the given server
     * handle. All objects created by the client will be garbage
     * collected.
     *
     * @param handle the server handle pointer.
     **/
    void destroyClient(ServerHandleImpl *handle);

    /**
     * Terminate the server.
     **/
    void terminate() { 
	_quit = true;
    }

private:

    // Server cannot be assigned or copy constructed
    ServerImpl(const ServerImpl &);
    ServerImpl &operator = (const ServerImpl &);

    struct client_t {
	CORBA::String_var name;
	ServerHandleImpl *handle;
	Nobel::ClientHandle_var client;
	client_t(const char *n, ServerHandleImpl *h, Nobel::ClientHandle_var c)
	    : name(CORBA::string_dup(n)), handle(h), client(c) {}
    };
    typedef std::list<client_t> clist_t;
    
    Mutex _mutex;
    clist_t _clients;
    SceneManager *_smanager;
    bool _quit;
};

#endif /* ServerImpl.hh */
