/* ------------------------------------------------------------------------
 * PointGeometryImpl.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-21 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _PointGeometryImpl_hh_
#define _PointGeometryImpl_hh_

// -- 3Dwm Includes
#include "Polhem/GeometryImpl.hh"
#include "Nobel/PointGeometry.hh"

// -- Class Declarations

class PointGeometryImpl : public virtual POA_Nobel::PointGeometry,
                          public GeometryImpl {
public:
    
    /**
     * Default constructor
     **/
    PointGeometryImpl() { }
    
    /**
     * Destructor
     **/
    virtual ~PointGeometryImpl() { }
    
    // IDL functions
    virtual void render(Nobel::Renderer_ptr r);
    virtual void setVertexNumber(CORBA::Long n);
    virtual void setVertex(CORBA::Long index, const Nobel::Vertex3D &v);
    virtual Nobel::Vertex3D getVertex(CORBA::Long index);
    virtual Nobel::PointMesh *getMesh();
    virtual void setMesh(const Nobel::PointMesh &mesh);
    
protected:
    
    /**
     * Recompute bounding volume. This will step through all the
     * vertices in the geometry and recreate the bounding volume for
     * it.
     **/
    virtual void recomputeBoundingVolume();

    Nobel::PointMesh _mesh;
};

#endif /* PointGeometryImpl.hh */
