/* ------------------------------------------------------------------------
 * $Id: Time.hh,v 1.1 2001/06/09 14:44:51 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-08 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Time_hh_
#define _Time_hh_

// -- System Includes

// -- Class Declarations

/**
 * Time management class. 
 **/
class Time {

public:

    /**
     * Retrieve the current time measured as the number of seconds
     * since the last Epoch (00:00:00 UTC, January 1, 1970).
     *
     * @return number of seconds since the last Epoch.
     **/
    static double time();

    /**
     * Sleep for a given time. 
     *
     * @param number of seconds to sleep. 
     **/
    static void sleep(double time); 
    
};

#endif /* Time.hh */
