/* ------------------------------------------------------------------------
 * $Id: Thread.hh,v 1.8 2001/06/29 15:00:38 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-06-19 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Thread_hh_
#define _Thread_hh_

// -- System Includes
#include <pthread.h>

// -- Local Includes
#include "Runnable.hh"

// -- Class Declarations

/**
 * Simple Java-like implementation of POSIX threads.
 *
 * This class should really be turned into an abstract superclass and
 * then have different implementations of it using different thread
 * libraries. Then we need object factories for constructing the 
 * different implementations of the thread objects. 
 **/
class Thread {
    
public:
    
    /** 
     * Constructor. Takes a runnable object as an argument.
     *
     * @param target the object to run in the thread.
     **/
    Thread(Runnable *target);    
    
    /**
     * Destructor.
     **/
    virtual ~Thread();
    
    /**
     * Start this thread using the passed Runnable object. This will
     * create the actual thread and call the run() method on the
     * current Thread object. The thread will continue to run until
     * the run() method of the Runnable object returns.
     **/
    virtual void start();    

    /**
     * Wait for the termination of this thread. If the thread is not
     * running, the method will just return and do nothing.
     **/
    virtual void join();
    
    /**
     * Is this thread running?
     *
     * @return true if the thread is running.
     **/
    bool isRunning(void) const {
	return _running; 
    }

    /**
     * Call the run() method of the Runnable object. (Use the start()
     * function to actually start the thread!) Don't use this method
     * directly!
     **/
    virtual void run();

    /**
     * Kill the current thread. The thread will be cancelled and stop
     * execution.
     **/
    virtual void kill();
        
protected:
    
    
    /// POSIX thread object
    pthread_t _thread;
    
    /// Runnable object to call when executing thread

    Runnable *_target;
    
    /// Is the thread running or not?
    bool _running;
};

#endif /* thread.hh */

