/* ------------------------------------------------------------------------
 * $Id: LocatorImpl.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-14 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXLocatorImpl_hh_
#define _SAXLocatorImpl_hh_

// -- System Includes
#include <string>

// -- Local Includes
#include "Celsius/SAX/Locator.hh"

namespace SAX {

    // -- Class Declarations

    /**
     * Provide an optional convenience implementation of Locator. 
     **/
    class LocatorImpl : public Locator {
    public:
	
	/**
	 * Constructor.
	 **/
	LocatorImpl() { }

	/**
	 * Constructor.
	 *
	 * @param publicId public identifier, empty if none is available.
	 * @param systemId system identifier, empty if none is available.
	 * @param lineNumber line number, or -1 if none is available.
	 * @param columnNumber column number, or -1 if none is available.
	 **/
	LocatorImpl(const std::string &publicId, const std::string &systemId,
		    int lineNumber, int columnNumber) : 
	    _publicId(publicId), _systemId(systemId), 
	    _line(lineNumber), _col(columnNumber) { }
	
	/**
	 * Copy constructor.
	 **/
	LocatorImpl(const Locator &l) { copy(l); }
	
	/**
	 * Destructor.
	 **/
	virtual ~LocatorImpl() { }

	/**
	 * Return the public identifier for the current document event.
	 *
	 * @return string containing the public identifier, empty if
	 *         none is available.
	 **/
	virtual const std::string &getPublicId() const {
	    return _publicId;
	}
	
	/**
	 * Return the system identifier for the current document event. 
	 *
	 * @return string containing the system identifier, empty if
	 *         none is available.
	 **/
	virtual const std::string &getSystemId() const {
	    return _systemId; 
	}

	/**
	 * Return the line number where the current document event ends. 
	 *
	 * @return line number, or -1 if none is available.
	 **/
	virtual int getLineNumber() const {
	    return _line;
	}

	/**
	 * Return the column number where the current document event ends.
	 * 
	 * @return column number, or -1 if none is available.
	 **/
	virtual int getColumnNumber() const {
	    return _col; 
	}
	
	/**
	 * Set the public identifier for this locator.
	 *
	 * @param publicId new public identifier, empty if none is available.
	 **/
	void setPublicId(const std::string &publicId) {
	    _publicId = publicId; 
	}

	/**
	 * Set the system identifier for this locator.
	 *
	 * @param systemId new system identifier, empty if none is available.
	 **/
	void setSystemId(const std::string &systemId) {
	    _systemId = systemId; 
	}
	
	/**
	 * Set the line number for this locator (1-based).
	 *
	 * @param lineNumber line number, or -1 if none is available.
	 **/
	void setLineNumber(int lineNumber) {
	    _line = lineNumber; 
	}
	
	/**
	 * Set the column number for this locator (1-based).
	 *
	 * @param columnNumber column number, or -1 if none is available.
	 **/
	void setColumnNumber(int columnNumber) {
	    _col = columnNumber; 
	}
	
    private:

	void copy(const Locator &l) {
	    _publicId = l.getPublicId();
	    _systemId = l.getSystemId();
	    _line = l.getLineNumber();
	    _col = l.getColumnNumber();
	}
	
	std::string _publicId;
	std::string _systemId;
	int _line, _col;
    };
};

#endif /* LocatorImpl.hh */
