/* ------------------------------------------------------------------------
 * $Id: AttributeList.hh,v 1.1 2001/08/16 11:32:21 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * This C++ SAX implementation (Simple API for XML) is derived from
 * David Megginson's original Java SAX that can be found on 
 * http://www.megginson.com/SAX/.
 * ------------------------------------------------------------------------
 * File created 2001-08-13 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------ 
 */

#ifndef _SAXAttributeList_hh_
#define _SAXAttributeList_hh_

// -- System Includes
#include <string>

namespace SAX {

    // -- Class Declarations

    /**
     * Interface for a list of XML attributes.
     **/
    class AttributeList {
    public:

	/**
	 * Constructor.
	 **/
	AttributeList() { }
	
	/**
	 * Destructor.
	 **/
	virtual ~AttributeList() { }

	/**
	 * Return the number of attributes in this list.
	 *
	 * @return number of attributes in the list.
	 **/
	virtual int getLength() const = 0;

	/**
	 * Return the name of an attribute in this list (by position).
	 *
	 * @param i index of the attribute in the list (starting at 0). 
	 * @return name of the indexed attribute.
	 **/
	virtual const std::string &getName(int i) const = 0;

	/**
	 * Return the type of an attribute in the list (by position).
	 * The attribute type is one of the strings "CDATA", "ID",
	 * "IDREF", "IDREFS", "NMTOKEN", "NMTOKENS", "ENTITY",
	 * "ENTITIES", or "NOTATION" (always in upper case).
	 *
	 * @param i index of the attribute in the list (starting at 0).
	 * @return attribute type as a string.
	 **/
	virtual const std::string &getType(int i) const = 0;
	
	/**
	 * Return the type of an attribute in the list (by name). The
	 * attribute type is one of the strings "CDATA", "ID",
	 * "IDREF", "IDREFS", "NMTOKEN", "NMTOKENS", "ENTITY",
	 * "ENTITIES", or "NOTATION" (always in upper case).
	 *
	 * @param name name of the attribute.
	 * @return attribute type as a string.
	 **/
	virtual const std::string &getType(const std::string &name) const = 0;
	
	/**
	 * Return the value of an attribute in the list (by
	 * position). If the attribute value is a list of tokens
	 * (IDREFS, ENTITIES, or NMTOKENS), the tokens will be
	 * concatenated into a single string separated by whitespace.
	 *
	 * @param i index of the attribute in the list (starting at 0).
	 * @return attribute value as a string.
	 **/
	virtual const std::string &getValue(int i) const = 0;
	
	/**
	 * Return the value of an attribute in the list (by name). If
	 * the attribute value is a list of tokens (IDREFS, ENTITIES,
	 * or NMTOKENS), the tokens will be concatenated into a single
	 * string separated by whitespace.
	 *
	 * @param name name of the attribute.
	 * @return attribute value as a string.
	 **/
	virtual const std::string &getValue(const std::string &name) const = 0;
    };

};

#endif /* AttributeList.hh */
