/* ------------------------------------------------------------------------
 * Exception.hh
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-11-24 by Niklas Elmqvist.
 *
 * Copyright (c) 2000 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _Exception_hh_
#define _Exception_hh_

// -- System Includes
#include <iostream>
#include <exception>
#include <string>

// -- Class Declarations
class Exception : public std::exception {
    
public:
    
    /**
     * Default constructor.
     * 
     * @param msg the exception message.
     **/
    Exception(const char *msg = 0) : _msg(msg), _e(0) { }

    /**
     * Constructor.
     *
     * @param msg exception message.
     **/
    Exception(const std::string &msg) : _msg(msg), _e(0) { }
    
    /**
     * Constructor.
     *
     * @param e the exception.
     **/
    Exception(std::exception &e) : _e(&e) { }

    /**
     * Destructor.
     **/
    virtual ~Exception() throw() { }

    /**
     * Retrieve the exception cause (what caused the exception).
     **/
    virtual const char *what() const throw() { 
	return _msg.empty() == true ? _e->what() : _msg.c_str(); 
    }

    /**
     * Retrieve the actual (standard) exception object.
     **/
    std::exception *getException() const {
	return _e; 
    }
    
private:
    
    std::string _msg;
    std::exception *_e;
};

/**
 * Exception output operator.
 * 
 * @param os output stream.
 * @param exception exception object.
 * @return the (modified) output stream.
 **/
inline std::ostream &operator << (std::ostream &os, const Exception &exception)
{
    return os << (exception.what() == 0 ? "<exception>" : exception.what());
}

/**
 * Exception output operator (for exception pointers).
 *
 * @param os output stream.
 * @param exception exception object pointer.
 * @return the (modified) output stream.
 **/
inline std::ostream &operator << (std::ostream &os, Exception *exception)
{
    return os << *exception;
}

#endif /* Exception.hh */
