dnl $Id: xml.m4,v 1.1 2001/08/21 14:43:01 elm Exp $
dnl
dnl This file is part of 3Dwm: The Three-Dimensional User Environment.
dnl
dnl 3Dwm: The Three-Dimensional User Environment:
dnl	<http://www.3dwm.org>
dnl
dnl Chalmers Medialab
dnl 	<http://www.medialab.chalmers.se>
dnl 
dnl ------------------------------------------------------------------------
dnl File created 2001-08-21 by Niklas Elmqvist (contributed by Bruce
dnl Mitchener).
dnl
dnl Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
dnl ------------------------------------------------------------------------
dnl This library is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU Lesser General Public
dnl License as published by the Free Software Foundation; either
dnl version 2.1 of the License, or (at your option) any later version.
dnl 
dnl This library is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl Lesser General Public License for more details.
dnl 
dnl You should have received a copy of the GNU Lesser General Public
dnl License along with this library; if not, write to the Free Software
dnl Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
dnl USA
dnl ------------------------------------------------------------------------

dnl ##
dnl ## Check for XML backend (expat, at the moment).
dnl ##

AC_DEFUN(TDWM_HAVE_XML_LIB,[dnl

dnl # Clear the XML build flags
XML_LIBS_L=""
XML_LIBS_I=""

dnl # Check for expat directory argument
AC_ARG_WITH(expat,
	[  --with-expat=DIR        Specify location of expat],
	[  EXPAT_PREFIX=$withval
		if test -n "$EXPAT_PREFIX" -a ! "$EXPAT_PREFIX" = "yes"; then
   			XML_LIBS_L="-L$EXPAT_PREFIX/lib";
			XML_LIBS_I=-"I$EXPAT_PREFIX/include";
		fi
	])

dnl # Save linking flags and temporarily set new ones
_SAVE_LDFLAGS="$LDFLAGS"
_SAVE_CFLAGS="$XML_LIBS_I $CFLAGS"
LDFLAGS="$XML_LIBS_L $LDFLAGS -lexpat"

dnl # Check for the existence of expat libs and headers
AC_CHECK_LIB(
	expat,
	XML_Parse,
	AC_CHECK_HEADER(
		expat.h, 
		[ XML_LIBS_L="$XML_LIBS_L -lexpat" ; ],
		[AC_MSG_ERROR([You must have expat development files installed. Please see the installation instructions.])]),
	[AC_MSG_ERROR([You must have expat installed.  Please see the installation instructions.])])

dnl # Restore linking flags
LDFLAGS="$_SAVE_LDFLAGS"
CFLAGS="$_SAVE_CFLAGS"

dnl # Substitute variables
AC_SUBST(XML_LIBS_L)
AC_SUBST(XML_LIBS_I)

])dnl
