#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

extern struct setup Setup;
extern struct statxmysqladmin Stat;
FD_dropdb *f_dropdb;
char g_dropdb_dbfname[33];

void main_createdb(FL_OBJECT *obj, long data)
{
  
  strncpy(g_dropdb_dbfname, fl_show_simple_input("Enter the new database name", ""), 32);
  if(g_dropdb_dbfname[0])  
    {
      MYSQL connection;
      if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
	{
	  if(mysql_create_db(&connection, g_dropdb_dbfname))
	    {
	      fl_show_alert(mysql_error(&connection),"","",0);
	    }
	  else
	    {
	      fl_show_message("The database",g_dropdb_dbfname,"has been created");
	    }
	  mysql_close(&connection);
	}
      else
	{
	  fl_show_alert("Cannot connect to server","","",0);
	}
    }
}


void main_dropdb(FL_OBJECT *obj, long data)
{
  if(Stat.flagDropdb) return;
  Stat.flagDropdb=1;
  
  f_dropdb = create_form_dropdb();
  fl_show_form(f_dropdb->dropdb, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin dropdb");
  fl_freeze_form(f_dropdb->dropdb);

  fl_deactivate_object(f_dropdb->drop);
  fl_set_object_lcol(f_dropdb->drop, FL_INACTIVE);
  browser_getDatabases(f_dropdb->browser);  
  fl_unfreeze_form(f_dropdb->dropdb);
}

void dropdb_exit(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_dropdb->dropdb);
  fl_free_form(f_dropdb->dropdb);
  free(f_dropdb);
  Stat.flagDropdb=0;
}


void dropdb_browser(FL_OBJECT *obj, long data)
{
  int ligne;
  
  ligne = fl_get_browser(obj);

  if(ligne > 0)
    {
      strcpy(g_dropdb_dbfname, fl_get_browser_line(obj, ligne));  
      if(g_dropdb_dbfname[0] && strcmp(g_dropdb_dbfname, "mysql"))
	{
	  fl_activate_object(f_dropdb->drop);
	  fl_set_object_lcol(f_dropdb->drop, FL_BLACK);
	}
      else
	{
	  fl_deactivate_object(f_dropdb->drop);
	  fl_set_object_lcol(f_dropdb->drop, FL_INACTIVE);
	}
    }
  else
    {
      fl_deactivate_object(f_dropdb->drop);
      fl_set_object_lcol(f_dropdb->drop, FL_INACTIVE);
    }
}			  
			  
void dropdb_drop(FL_OBJECT *obj, long data)
{
  char *cmd;
  
  if(!fl_show_question("WARNING!!!\nThis database will be delete.\nDo you want to continue?", 0))
	return;
  if(!fl_show_question("WARNING!!!\nThis database will be delete.\nAre you sure?", 0))
	return;

  cmd = (char *) malloc(2048);
  if(!cmd) return;
  
  sprintf(cmd, "%s %s/%s.tar%s %s%s/*", BACKUP, BACKUPDIR, g_dropdb_dbfname, 
	  BACKUPSUFFIX, Setup.datapath, g_dropdb_dbfname);
  
  fl_show_command_log(FL_TRANSIENT);
  fl_exe_command(cmd, 1); 
  free(cmd);
  
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      if(mysql_drop_db(&connection, g_dropdb_dbfname))
	{
	  fl_show_alert(mysql_error(&connection),"","",0);
	}
      else
	{
	  fl_show_message("The database",g_dropdb_dbfname,"has been destroyed");
	}

      mysql_close(&connection);
    }
    else
      {
	  fl_show_alert("Cannot connect to server","","",0);
      }
  }

  
  fl_freeze_form(f_dropdb->dropdb);
  fl_deactivate_object(f_dropdb->drop);
  fl_set_object_lcol(f_dropdb->drop, FL_INACTIVE);
  browser_getDatabases(f_dropdb->browser);  
  fl_unfreeze_form(f_dropdb->dropdb);


}


