/* CDLFONT.H -- Font definitions.
 */

#define	CHARACTER_START 	32
#define	CHARACTER_END 		126
#define	CHARACTER_HEIGHT 	26
#define	CHARACTER_WIDTH 	17

#define	FONT_LEFT 		0
#define	FONT_CENTER 		9
#define	FONT_RIGHT 		27
#define	FONT_TOP 		36
#define	FONT_CAP 		34
#define	FONT_HALF 		23
#define	FONT_BASE 		9
#define	FONT_BOTTOM 		0
#define	FONT_WIDTH 		27
#define	FONT_HEIGHT 		36

#define	COORD_X_START 		7
#define	COORD_Y_START 		1
#define	COORD_PEN_START 	13
#define	COORD_X_LEN 		6
#define	COORD_Y_LEN 		6
#define	COORD_PEN_LEN 		1

#define	PAINT_BEGIN_START	14
#define	PAINT_END_START 	15
#define	PAINT_BEGIN_LEN 	1
#define	PAINT_END_LEN 		1


/* CHRTAB -- Table of strokes for the printable ASCII characters.  Each char-
 * acter is encoded as a series of strokes.  Each stroke is expressed by a
 * single integer containing the following bitfields:
 *
 *	2                   1
 *	0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 
 *	          | | | |         | |         |
 *		  | | | +---------+ +---------+
 *		  | | |      |           |
 *		  | | |      X           Y
 *		  | | |
 *	          | | +-- pen up/down
 *                 | +---- begin paint (not used at present)
 *                 +------ end paint (not used at present)
 *------------------------------------------------------------------------------
 */

/* Define the database.  */


/* Index into CHRTAB of each printable character (starting with SP). */

short	chridx[] = {		/* character index in chrtab  		*/
	   1,   3,  12,  21,  30,  45,  66,  79,  85,  92,
	  99, 106, 111, 118, 121, 128, 131, 141, 145, 154,
	 168, 177, 187, 199, 203, 221, 233, 246, 259, 263,
	 268, 272, 287, 307, 314, 327, 336, 344, 352, 359,
	 371, 378, 385, 391, 398, 402, 408, 413, 425, 433,
	 445, 455, 468, 473, 480, 484, 490, 495, 501, 506,
	 511, 514, 519, 523, 526, 529, 543, 554, 563, 574,
	 585, 593, 607, 615, 625, 638, 645, 650, 663, 671,
	 681, 692, 703, 710, 723, 731, 739, 743, 749, 754,
	 759, 764, 776, 781, 793, 801
};


short	chrtab[] = {		/* stroke data to draw the characters  	*/
	   36,  1764,   675, 29328,   585, 21063, 21191, 21193, 21065, 29383, 
	 1764,   355, 29023,   351, 29027,   931, 29599,   927, 29603,  1764, 
	  603, 29066,   842, 29723,  1302, 28886,   143, 29839,  1764,   611, 
	29256,    78, 20810, 21322, 21581, 21586, 21334, 20822, 20569, 20573, 
	20833, 21345, 29789,  1764,   419, 20707, 20577, 20574, 20700, 20892, 
	21022, 21025, 20899,  1187, 28744,   717, 21194, 21320, 21512, 21642, 
	21645, 21519, 21327, 21197,  1764,  1160, 20700, 20704, 20835, 21027, 
	21152, 21149, 20561, 20556, 20744, 21192, 29841,  1764,   611, 21023, 
	21087, 21155, 21091,  1764,   739, 21087, 21018, 21009, 21068, 29384, 
	 1764,   547, 21151, 21210, 21201, 21132, 29192,  1764,    93, 29774, 
	  608, 29259,    78, 29789,  1764,   604, 29260,    84, 29780,  1764, 
	  516, 21062, 21065, 21001, 21000, 21064,  1764,    84, 29780,  1764, 
	  585, 21063, 21191, 21193, 21065, 21191,  1764,    72, 29859,  1764, 
	  419, 20573, 20558, 20872, 21320, 21646, 21661, 21347, 20899,  1764, 
	  221, 21155, 29320,  1764,    95, 20835, 21411, 21663, 21655, 20556, 
	20552, 29832,  1764,    95, 20899, 21347, 21663, 21658, 21334, 29270, 
	  854,  5266, 21644, 21320, 20872, 28749,  1764,   904, 21411, 21283, 
	20561, 20559, 21391,   911, 13455,  1764,   136, 21320, 21645, 21652, 
	21337, 20889, 20565, 20579, 29859,  1764,    83, 20888, 21336, 21651, 
	21645, 21320, 20872, 20557, 20563, 20635, 29347,  1764,    99, 21667, 
	29064,  1764,   355, 20575, 20570, 20822, 20562, 20556, 20808, 21384, 
	21644, 21650, 21398, 20822,   918,  5274, 21663, 21411, 20835,  1764, 
	  648, 21584, 21656, 21662, 21347, 20899, 20574, 20568, 20883, 21331, 
	21656,  1764,   602, 21210, 21207, 21079, 21082, 21207,   592, 21069, 
	21197, 21200, 21072, 21197,  1764,   602, 21146, 21143, 21079, 21082, 
	21143,   585, 21132, 21136, 21072, 21071, 21135,  1764,   988, 20628, 
	29644,  1764,  1112, 28824,   144, 29776,  1764,   156, 21460, 28812, 
	 1764,   221, 20704, 20899, 21218, 21471, 21466, 21011, 21007,   521, 
	20999, 21127, 21129, 21001, 21127,  1764,   908, 20812, 20560, 20571, 
	20831, 21407, 21659, 21651, 21521, 21393, 21331, 21335, 21210, 21018, 
	20887, 20883, 21009, 21201, 21331,  1764,    72, 20963, 21219, 29768, 
	  210,  5074,  1764,    99, 21411, 21663, 21658, 21398, 20566,   918, 
	 5266, 21644, 21384, 20552, 20579,  1764,  1165, 21320, 20872, 20557, 
	20574, 20899, 21347, 29854,  1764,    99, 21347, 21662, 21645, 21320, 
	20552, 20579,  1764,    99, 20552, 29832,    86, 13078,    99, 29859, 
	 1764,    99, 20552,    86, 13078,    99, 29859,  1764,   722, 21650, 
	29832,  1165,  4936, 20872, 20557, 20574, 20899, 21347, 29854,  1764, 
	   99, 28744,    85,  5269,  1160, 29859,  1764,   291, 29603,   611, 
	 4680,   328, 29576,  1764,    77, 20872, 21256, 21581, 29795,  1764, 
	   99, 28744,  1160, 20887,    82, 13475,  1764,    99, 20552, 29832, 
	 1764,    72, 20579, 21077, 21603, 29768,  1764,    72, 20579, 21640, 
	29859,  1764,    94, 20899, 21347, 21662, 21645, 21320, 20872, 20557, 
	20574,   862, 29859,  1764,    72, 20579, 21411, 21663, 21656, 21396, 
	20564,  1764,    94, 20557, 20872, 21320, 21645, 21662, 21347, 20899, 
	20574,   536, 29828,  1764,    72, 20579, 21411, 21663, 21657, 21398, 
	20566,   918, 13448,  1764,    76, 20808, 21384, 21644, 21649, 21397, 
	20822, 20570, 20575, 20835, 21411, 29855,  1764,   648, 21155,    99, 
	29923,  1764,    99, 20557, 20872, 21320, 21645, 29859,  1764,    99, 
	21064, 29795,  1764,    99, 20808, 21141, 21448, 29923,  1764,    99, 
	29832,    72, 29859,  1764,    99, 21079, 29256,   599, 13411,  1764, 
	   99, 21667, 20552, 29832,  1764,   805, 20965, 20935, 29447,  1764, 
	   99, 29832,  1764,   421, 21221, 21191, 29063,  1764,   288, 21091, 
	29600,  1764,     3, 29891,  1764,   547, 29341,  1764,   279, 21207, 
	21396, 21387, 21127, 20807, 20555, 20558, 20753, 21201, 21391,   907, 
	13447,  1764,    99, 28744,    76,  4424, 21256, 21516, 21523, 21271, 
	20823, 20563,  1764,   981, 21271, 20823, 20563, 20556, 20808, 21256, 
	29642,  1764,  1043,  4887, 20823, 20563, 20556, 20808, 21256, 21516, 
	 1032, 29731,  1764,    80,  5136, 21523, 21271, 20823, 20563, 20556, 
	20808, 21256, 29707,  1764,   215, 29591,   456, 20958, 21153, 21409, 
	29727,  1764,    67, 20800, 21248, 21508, 29719,  1043, 21271, 20823, 
	20563, 20556, 20808, 21256, 21516,  1764,    99, 28744,    83,  4439, 
	21271, 21523, 29704,  1764,   541, 21019, 21147, 21149, 21021, 21147, 
	  533, 21077, 29256,  1764,   541, 21019, 21147, 21149, 21021, 21147, 
	  533, 21077, 21058, 20928, 20736, 28802,  1764,    99, 28744,    84, 
	29530,   342, 13320,  1764,   483, 21089, 21066, 29384,  1764,    87, 
	28744,   584, 21076,    84,  4375, 20951, 21076, 21207, 21399, 21588, 
	29768,  1764,    87, 28744,    83, 20823, 21271, 21523, 29704,  1764, 
	   83, 20556, 20808, 21256, 21516, 21523, 21271, 20823, 20563,  1764, 
	   87, 28736,    83, 20823, 21271, 21523, 21516, 21256, 20808, 20556, 
	 1764,  1047, 29696,  1036, 21256, 20808, 20556, 20563, 20823, 21271, 
	21523,  1764,    87, 28744,    83, 20823, 21271, 29716,  1764,    74, 
	20808, 21256, 21514, 21518, 21264, 20816, 20562, 20565, 20823, 21271, 
	21461,  1764,   279, 29591,   970, 21320, 21128, 21002, 21025,  1764, 
	   87, 20556, 20808, 21256, 21516,  1032, 29719,  1764,   151, 21064, 
	29719,  1764,    87, 20808, 21077, 21320, 29783,  1764,   151, 29704, 
	  136, 29719,  1764,    87, 21064,   320, 29783,  1764,   151, 21527, 
	20616, 29704,  1764,   805, 21157, 21026, 21017, 20951, 20822, 20949, 
	21011, 21001, 21127, 21255,  1764,   611, 29273,   594, 29256,  1764, 
	  485, 21093, 21218, 21209, 21271, 21398, 21269, 21203, 21193, 21063, 
	29127,  1764,    83, 20758, 20950, 21265, 21457, 29844,  1764,     0
};


/* Greek character index in gchtab */
short	gchidx[] = {    /* character index in gchtab */
	    1,    3,   16,   29,   38,   77,  107,  154,  162,  181,  200,  205,
	  212,  233,  240,  246,  259,  297,  306,  348,  392,  402,  437,  483,
	  510,  568,  614,  645,  658,  666,  673,  681,  688,  741,  767,  793,
	  795,  806,  821,  863,  874,  883,  888,  899,  901,  912,  921,  930,
	  972,  987, 1037, 1067, 1083, 1088, 1117, 1143, 1182, 1207, 1242, 1244,
	 1253, 1256, 1265, 1267, 1276, 1284, 1321, 1373, 1394, 1436, 1465, 1500,
	 1520, 1549, 1563, 1605, 1630, 1650, 1674, 1694, 1724, 1741, 1783, 1812,
	 1844, 1857, 1886, 1888, 1929, 1970, 2001, 2031, 2069, 2074, 2112, 2121,
};

/* Width data. */
short	gchwid[] = {    /* width data in gchtab */
	   21,   15,   15,   26,   25,   29,   30,   15,   19,   19,
	   27,   29,   30,   29,   15,   31,   25,   25,   25,   25,
	   25,   25,   25,   25,   25,   25,   29,   15,   29,   31,
	   29,   31,   32,   25,   30,   21,   25,   29,   26,   23,
	   26,   19,   25,   21,   25,   21,   21,   27,   29,   27,
	   29,   26,   19,   24,   25,   27,   27,   28,   21,   19,
	   19,   19,   21,   31,   27,   28,   26,   23,   24,   23,
	   27,   25,   27,   17,   24,   25,   25,   28,   25,   23,
	   27,   28,   24,   26,   25,   25,   21,   28,   22,   28,
	   23,   19,   19,   19,   31,   19 
};

/* Stroke data. */
short	gchtab[] = {    /* stroke data in gchtab */
	   35,    0,  220, 4250, 4302, 4378, 4316,  218, 4308,  201,
	 4232, 4295, 4360, 4297,    0,  213, 4244, 4307, 4372, 4309,
	  199, 4232, 4297, 4360, 4358, 4292, 4227,    0,  604, 4224,
	  988, 4608,  145, 5137,   75, 5067,    0,  416, 4483,  672,
	 4739,  921, 4952, 5015, 5080, 5081, 4955, 4764, 4508, 4315,
	 4185, 4183, 4245, 4308, 4435, 4817, 4944, 5070,   87, 4309,
	 4436, 4818, 4945, 5008, 5070, 5066, 4936, 4743, 4487, 4296,
	 4170, 4171, 4236, 4299, 4234,    0, 1244, 4167,  412, 4634,
	 4632, 4566, 4437, 4309, 4183, 4185, 4251, 4380, 4508, 4635,
	 4826, 5018, 5211, 5340,  974, 4941, 4875, 4873, 4999, 5127,
	 5256, 5322, 5324, 5198, 5070,    0, 1236, 5267, 5330, 5395,
	 5396, 5333, 5269, 5204, 5138, 5005, 4874, 4744, 4615, 4423,
	 4232, 4170, 4173, 4239, 4627, 4757, 4823, 4825, 4763, 4636,
	 4507, 4441, 4439, 4500, 4625, 4938, 5064, 5255, 5319, 5384,
	 5385,  327, 4296, 4234, 4237, 4303, 4433,  343, 4501, 5002,
	 5128, 5255,    0,  218, 4251, 4316, 4379, 4377, 4311, 4246,
	    0,  608, 4574, 4443, 4311, 4242, 4238, 4297, 4421, 4546,
	 4672,  478, 4442, 4375, 4306, 4302, 4361, 4422, 4546,    0,
	   96, 4318, 4443, 4567, 4626, 4622, 4553, 4421, 4290, 4160,
	  222, 4442, 4503, 4562, 4558, 4489, 4422, 4290,    0,  151,
	 5129, 1047, 4233,    0,  664, 4743,  144, 5264,  135, 5255,
	    0, 1227, 5195, 5068, 4942, 4754, 4691, 4564, 4436, 4307,
	 4241, 4239, 4301, 4428, 4556, 4685, 4750, 4946, 5076, 5205,
	 5333,    0,  664, 4743,  152, 5272,  144, 5264,    0,  201,
	 4232, 4295, 4360, 4297,    0,  729, 4760, 4823, 4888, 4825,
	  144, 5392,  713, 4744, 4807, 4872, 4809,    0,  476, 4379,
	 4248, 4179, 4176, 4235, 4360, 4551, 4679, 4872, 5003, 5072,
	 5075, 5016, 4891, 4700, 4572,  476, 4443, 4378, 4312, 4243,
	 4240, 4299, 4361, 4424, 4551,  583, 4808, 4873, 4939, 5008,
	 5011, 4952, 4890, 4827, 4700,    0,  280, 4505, 4700, 4679,
	  539, 4615,  263, 4935,    0,  152, 4311, 4246, 4183, 4184,
	 4250, 4315, 4508, 4764, 4955, 5018, 5080, 5078, 5012, 4818,
	 4496, 4367, 4237, 4170, 4167,  668, 4891, 4954, 5016, 5014,
	 4948, 4754, 4496,   73, 4234, 4362, 4680, 4872, 5001, 5066,
	  266, 4679, 4935, 5000, 5066, 5068,    0,  152, 4311, 4246,
	 4183, 4184, 4250, 4315, 4508, 4764, 4955, 5017, 5014, 4948,
	 4755, 4563,  668, 4891, 4953, 4950, 4884, 4755,  659, 4882,
	 5008, 5070, 5067, 5001, 4936, 4743, 4487, 4296, 4233, 4171,
	 4172, 4237, 4300, 4235,  849, 5006, 5003, 4937, 4872, 4743,
	    0,  666, 4743,  732, 4807,  732, 4109, 5133,  455, 4999,
	    0,  220, 4178,   82, 4308, 4501, 4693, 4884, 5010, 5071,
	 5069, 5002, 4872, 4679, 4487, 4296, 4233, 4171, 4172, 4237,
	 4300, 4235,  597, 4820, 4946, 5007, 5005, 4938, 4808, 4679,
	  220, 4956,  219, 4635, 4956,    0,  857, 4888, 4951, 5016,
	 5017, 4955, 4828, 4636, 4443, 4313, 4247, 4179, 4173, 4234,
	 4360, 4551, 4679, 4872, 5002, 5069, 5070, 5009, 4883, 4692,
	 4628, 4435, 4305, 4238,  540, 4507, 4377, 4311, 4243, 4237,
	 4298, 4424, 4551,  583, 4808, 4938, 5005, 5006, 4945, 4819,
	 4692,    0,   92, 4182,   88, 4250, 4380, 4508, 4825, 4953,
	 5018, 5084,  154, 4379, 4507, 4825,  988, 5081, 5014, 4753,
	 4687, 4620, 4615,  918, 4689, 4623, 4556, 4551,    0,  412,
	 4315, 4249, 4246, 4308, 4499, 4755, 4948, 5014, 5017, 4955,
	 4764, 4508,  412, 4379, 4313, 4310, 4372, 4499,  659, 4884,
	 4950, 4953, 4891, 4764,  403, 4306, 4241, 4175, 4171, 4233,
	 4296, 4487, 4743, 4936, 5001, 5067, 5071, 5009, 4946, 4755,
	  403, 4370, 4305, 4239, 4235, 4297, 4360, 4487,  647, 4872,
	 4937, 5003, 5007, 4945, 4882, 4755,    0,  917, 4946, 4816,
	 4623, 4559, 4368, 4242, 4181, 4182, 4249, 4379, 4572, 4700,
	 4891, 5017, 5078, 5072, 5004, 4938, 4808, 4615, 4423, 4296,
	 4234, 4235, 4300, 4363, 4298,  463, 4432, 4306, 4245, 4246,
	 4313, 4443, 4572,  604, 4827, 4953, 5014, 5008, 4940, 4874,
	 4744, 4615,    0, 1247, 5278, 5341, 5406, 5407, 5344, 5216,
	 5087, 4957, 4891, 4824, 4756, 4616, 4548, 4482,  926, 4956,
	 4888, 4748, 4680, 4613, 4547, 4417, 4288, 4160, 4097, 4098,
	 4163, 4226, 4161,    0,  213, 4244, 4307, 4372, 4309,  199,
	 4232, 4297, 4360, 4358, 4292, 4227,    0, 1180, 4245, 5262,
	  140, 5260,  135, 5255,    0,  149, 5397,  144, 5392,  139,
	 5387,    0,  156, 5269, 4238,  140, 5260,  135, 5255,    0,
	 1177, 4359,  147, 5395,  141, 5389,    0, 1044, 5078, 4951,
	 4759, 4630, 4565, 4498, 4495, 4557, 4684, 4876, 5005, 5071,
	  663, 4629, 4562, 4559, 4621, 4684, 1047, 5071, 5069, 5196,
	 5324, 5454, 5521, 5523, 5462, 5400, 5274, 5147, 4956, 4764,
	 4571, 4442, 4312, 4246, 4179, 4176, 4237, 4299, 4425, 4552,
	 4743, 4935, 5128, 5257, 5322, 1111, 5135, 5133, 5196,    0,
	  473, 4167,  601, 5063,  537, 4999,  205, 4877,    7, 4423,
	  711, 5191,  480, 4447, 4381, 4379, 4441, 4568, 4696, 4825,
	 4891, 4893, 4831, 4704, 4576,    0, 1295, 5325, 5196, 5068,
	 4941, 4878, 4690, 4627, 4500, 4372, 4243, 4177, 4175, 4237,
	 4364, 4492, 4621, 4686, 4882, 4947, 5076, 5204, 5331, 5393,
	 5391,    0,   35,    0,  540, 4103,  540, 5127,  537, 5063,
	   72, 5064,    7, 5127,    0, 1176, 4824, 4567, 4438, 4308,
	 4241, 4239, 4300, 4426, 4553, 4808, 5256,  144, 5008,    0,
	  540, 4615,  604, 4679,  407, 4310, 4245, 4179, 4176, 4238,
	 4301, 4492, 4812, 5005, 5070, 5136, 5139, 5077, 5014, 4823,
	 4503,  407, 4374, 4309, 4243, 4240, 4302, 4365, 4492,  716,
	 4941, 5006, 5072, 5075, 5013, 4950, 4823,  348, 4892,  327,
	 4871,    0,  220, 4295,  284, 4359,   28, 5084, 5078, 5020,
	    7, 4551,    0,  608, 4224,  992, 4608,  147, 5139,   77,
	 5069,    0,  160, 4224,  544, 4608,    0,   28, 4615,   92,
	 4617, 1052, 4615,   28, 5148,   91, 5083,    0,   35,    0,
	  540, 4167,  540, 5063,  537, 4999,    7, 4423,  711, 5191,
	    0,  278, 4505, 4630,   83, 4504, 4819,  408, 4487,    0,
	  266, 4487, 4618,   77, 4488, 4813,  409, 4488,    0,  540,
	 4443, 4313, 4247, 4179, 4176, 4236, 4298, 4424, 4615, 4743,
	 4936, 5066, 5132, 5200, 5203, 5143, 5081, 4955, 4764, 4636,
	  540, 4507, 4377, 4311, 4243, 4240, 4300, 4362, 4488, 4615,
	  647, 4872, 5002, 5068, 5136, 5139, 5079, 5017, 4891, 4764,
	    0,  220, 4295,  284, 4359, 1052, 5127, 1116, 5191,   28,
	 5404,    7, 4551,  839, 5383,    0,  540, 4443, 4313, 4247,
	 4179, 4176, 4236, 4298, 4424, 4615, 4743, 4936, 5066, 5132,
	 5200, 5203, 5143, 5081, 4955, 4764, 4636,  540, 4507, 4377,
	 4311, 4243, 4240, 4300, 4362, 4488, 4615,  647, 4872, 5002,
	 5068, 5136, 5139, 5079, 5017, 4891, 4764,  405, 4494,  789,
	 4878,  402, 4882,  401, 4881,    0, 1244, 4167,  412, 4634,
	 4632, 4566, 4437, 4309, 4183, 4185, 4251, 4380, 4508, 4635,
	 4826, 5018, 5211, 5340,  974, 4941, 4875, 4873, 4999, 5127,
	 5256, 5322, 5324, 5198, 5070,    0,   92, 4626, 4103,   28,
	 4562,   28, 5084, 5142, 5020,   72, 5000,    7, 5063, 5133,
	 4999,    0,  160, 4224,  544, 4608,    0,   23, 4121, 4187,
	 4252, 4380, 4443, 4505, 4565, 4551,   25, 4251, 4379, 4505,
	  983, 5081, 5019, 4956, 4828, 4763, 4697, 4629, 4615,  985,
	 4955, 4827, 4697,  263, 4807,    0,  473, 4167,  601, 5063,
	  537, 4999,  205, 4877,    7, 4423,  711, 5191,  480, 4447,
	 4381, 4379, 4441, 4568, 4696, 4825, 4891, 4893, 4831, 4704,
	 4576,    0,   74, 4231, 4487, 4363, 4239, 4178, 4182, 4249,
	 4379, 4572, 4828, 5019, 5145, 5206, 5202, 5135, 5003, 4871,
	 5127, 5194,  267, 4302, 4242, 4246, 4313, 4443, 4572,  732,
	 4955, 5081, 5142, 5138, 5070, 5003,  136, 4424,  840, 5128,
	    0,  157, 4184, 1117, 5144,  404, 4431,  852, 4879,  139,
	 4166, 1099, 5126,  155, 5147,  154, 5146,  402, 4882,  401,
	 4881,  137, 5129,  136, 5128,    0,  604, 4679,  668, 4743,
	   21, 4182, 4309, 4369, 4431, 4494, 4621,   86, 4245, 4305,
	 4367, 4430, 4621, 4813, 5006, 5071, 5137, 5205, 5270,  717,
	 4942, 5007, 5073, 5141, 5270, 5333,  412, 4956,  391, 4935,
	    0,   35,    0,  160, 4224,  224, 4288,  160, 4704,  128,
	 4672,    0,   28, 4868,    0,  480, 4544,  544, 4608,   96,
	 4640,   64, 4608,    0,   35,    0, 1106, 5392, 5198,  917,
	 5328, 5003,  144, 5328,    0,   85, 4437, 4809,  277, 4807,
	 1312, 4807,    0,  533, 4436, 4306, 4240, 4173, 4170, 4232,
	 4423, 4551, 4680, 4875, 5006, 5138, 5205,  533, 4500, 4370,
	 4304, 4237, 4234, 4296, 4423,  533, 4757, 4884, 4946, 5066,
	 5128, 5191,  661, 4820, 4882, 5002, 5064, 5191, 5255,    0,
	  732, 4635, 4505, 4373, 4306, 4238, 4168, 4096,  732, 4699,
	 4569, 4437, 4370, 4302, 4232, 4160,  732, 4956, 5083, 5146,
	 5143, 5077, 5012, 4819, 4563,  860, 5082, 5079, 5013, 4948,
	 4819,  467, 4818, 4944, 5006, 5003, 4937, 4872, 4679, 4551,
	 4424, 4361, 4300,  467, 4754, 4880, 4942, 4939, 4873, 4808,
	 4679,    0,   21, 4245, 4372, 4434, 4739, 4801, 4864,  149,
	 4308, 4370, 4675, 4737, 4864, 4992,  981, 5011, 4880, 4229,
	 4098, 4096,    0,  724, 4693, 4565, 4372, 4241, 4174, 4171,
	 4233, 4296, 4423, 4551, 4744, 4875, 4942, 4945, 4883, 4632,
	 4570, 4572, 4637, 4765, 4892, 5018,  469, 4436, 4305, 4238,
	 4234, 4296,  455, 4680, 4811, 4878, 4882, 4820, 4695, 4633,
	 4635, 4700, 4828, 5018,    0,  850, 4820, 4693, 4437, 4308,
	 4306, 4432, 4623,  341, 4372, 4370, 4496, 4623,  527, 4302,
	 4172, 4170, 4232, 4423, 4615, 4744, 4874,  527, 4366, 4236,
	 4234, 4296, 4423,    0,  404, 4371, 4241, 4174, 4171, 4233,
	 4296, 4423, 4615, 4808, 5002, 5133, 5200, 5203, 5077, 4949,
	 4819, 4687, 4554, 4352,   75, 4297, 4424, 4616, 4809, 5003,
	 5133, 1107, 5076, 4948, 4818, 4687, 4553, 4416,    0,  277,
	 4231,  341, 4367, 4298, 4231,  981, 5009, 4877, 1045, 5074,
	 5008, 4877, 4747, 4553, 4424, 4231,   85, 4437,    0,   17,
	 4115, 4245, 4437, 4500, 4498, 4430, 4295,  277, 4436, 4434,
	 4366, 4231,  334, 4562, 4692, 4821, 4949, 5076, 5139, 5136,
	 5067, 4864,  853, 5075, 5072, 5003, 4800,    0,  277, 4238,
	 4170, 4168, 4231, 4423, 4553, 4619,  341, 4302, 4234, 4232,
	 4295,    0,  848, 4883, 4820, 4693, 4565, 4372, 4241, 4174,
	 4171, 4233, 4296, 4423, 4551, 4744, 4874, 4941, 5010, 5015,
	 4954, 4891, 4764, 4572, 4443, 4378, 4377, 4441, 4442,  469,
	 4436, 4305, 4238, 4234, 4296,  455, 4680, 4810, 4877, 4946,
	 4951, 4890, 4764,    0,  277, 4103,  341, 4167,  917, 5076,
	 5140, 5077, 4949, 4820, 4560, 4431, 4303,  335, 4558, 4680,
	 4743,  335, 4494, 4616, 4679, 4807, 4936, 5067,    0,   92,
	 4316, 4443, 4506, 4568, 4938, 5000, 5063,  220, 4442, 4504,
	 4874, 4936, 5063, 5127,  533, 4103,  533, 4167,    0,  341,
	 4096,  405, 4096,  338, 4364, 4361, 4487, 4615, 4744, 4874,
	 5005, 1045, 4938, 4936, 4999, 5191, 5321, 5387, 1109, 5002,
	 5000, 5063,    0,  277, 4231,  341, 4367, 4298, 4231,  981,
	 5009, 4877, 1045, 5074, 5008, 4877, 4747, 4553, 4424, 4231,
	   85, 4437,    0,  469, 4372, 4241, 4174, 4171, 4233, 4296,
	 4423, 4551, 4744, 4875, 4942, 4945, 4883, 4820, 4693, 4565,
	  469, 4436, 4305, 4238, 4234, 4296,  455, 4680, 4811, 4878,
	 4882, 4820,    0,  468, 4295,  468, 4359,  852, 4935,  852,
	 4999,   18, 4244, 4437, 5269,   18, 4243, 4436, 5268,    0,
	   17, 4115, 4245, 4437, 4500, 4498, 4429, 4426, 4488, 4551,
	  277, 4436, 4434, 4365, 4362, 4424, 4551, 4679, 4808, 4938,
	 5069, 5136, 5205, 5209, 5147, 5020, 4892, 4762, 4760, 4821,
	 4946, 5072, 5262,  712, 4939, 5005, 5072, 5141, 5145, 5083,
	 5020,    0,  140, 4297, 4360, 4487, 4615, 4808, 4939, 5006,
	 5009, 4947, 4884, 4757, 4629, 4436, 4305, 4238, 4096,  519,
	 4744, 4875, 4942, 4946, 4884,  533, 4500, 4369, 4302, 4096,
	    0, 1109, 4565, 4372, 4241, 4174, 4171, 4233, 4296, 4423,
	 4551, 4744, 4875, 4942, 4945, 4883, 4820, 4693,  469, 4436,
	 4305, 4238, 4234, 4296,  455, 4680, 4811, 4878, 4882, 4820,
	  724, 5204,    0,  596, 4487,  596, 4551,   18, 4244, 4437,
	 5141,   18, 4243, 4436, 5140,    0,   17, 4115, 4245, 4437,
	 4500, 4498, 4364, 4361, 4487,  277, 4436, 4434, 4300, 4297,
	 4360, 4487, 4551, 4744, 4874, 5005, 5072, 5075, 5013, 4948,
	 5011, 5072,  909, 5075,    0,   35,    0,  145, 4371, 4564,
	 4501, 4372, 4241, 4174, 4171, 4232, 4295, 4423, 4552, 4683,
	 4750,   75, 4233, 4296, 4424, 4553, 4683,  590, 4683, 4744,
	 4807, 4935, 5064, 5195, 5262, 5265, 5204, 5141, 5076, 5203,
	 5265,  587, 4745, 4808, 4936, 5065, 5195,    0,  604, 4571,
	 4506, 4505, 4568, 4759, 4951,  663, 4502, 4373, 4307, 4305,
	 4431, 4622, 4814,  663, 4566, 4437, 4371, 4369, 4495, 4622,
	  526, 4365, 4236, 4170, 4168, 4294, 4612, 4675, 4673, 4544,
	 4416,  526, 4429, 4300, 4234, 4232, 4358, 4612,    0,  860,
	 4544,  924, 4480,   17, 4115, 4245, 4437, 4500, 4498, 4429,
	 4426, 4552, 4744, 4873, 5068, 5199,  277, 4436, 4434, 4365,
	 4362, 4424, 4551, 4743, 4872, 5002, 5133, 5199, 5333,    0,
	  604, 4571, 4506, 4505, 4568, 4759, 5079, 5080, 4887, 4629,
	 4435, 4240, 4173, 4171, 4233, 4423, 4613, 4675, 4673, 4608,
	 4480, 4417,  662, 4499, 4304, 4237, 4235, 4297, 4423,    0,
	  480, 4447, 4382, 4316, 4314, 4376, 4439, 4501, 4499, 4369,
	  351, 4381, 4379, 4441, 4504, 4566, 4564, 4498, 4240, 4494,
	 4556, 4554, 4488, 4423, 4357, 4355, 4417,  271, 4493, 4491,
	 4425, 4360, 4294, 4292, 4354, 4417, 4544,    0,  160, 4224,
	  544, 4608,    0,  224, 4447, 4510, 4572, 4570, 4504, 4439,
	 4373, 4371, 4497,  351, 4509, 4507, 4441, 4376, 4310, 4308,
	 4370, 4624, 4366, 4300, 4298, 4360, 4423, 4485, 4483, 4417,
	  399, 4365, 4363, 4425, 4488, 4550, 4548, 4482, 4417, 4288,
	    0,  338, 4240, 4430,  533, 4304, 4619,  208, 5392,    0,
	  284, 4251, 4185, 4183, 4245, 4372, 4500, 4629, 4695, 4697,
	 4635, 4508, 4380,    0,
};


/* Times Font data. */
short	timidx[] = {    /* character index in timtab */
	    1,    3,   16,   33,   42,   81,  111,  158,  163,  182,  201,  208,
	  213,  221,  224,  230,  233,  271,  280,  322,  366,  376,  411,  457,
	  484,  542,  588,  599,  612,  616,  621,  625,  655,  708,  721,  761,
	  792,  819,  836,  851,  887,  906,  915,  933,  952,  963,  984,  999,
	 1041, 1066, 1126, 1165, 1198, 1211, 1231, 1242, 1259, 1274, 1289, 1302,
	 1311, 1314, 1323, 1330, 1333, 1339, 1375, 1404, 1431, 1462, 1491, 1510,
	 1565, 1587, 1601, 1623, 1642, 1651, 1686, 1708, 1742, 1773, 1802, 1821,
	 1852, 1866, 1888, 1899, 1916, 1931, 1949, 1962, 2000, 2003, 2041, 2064,
};

/* Width data. */
short	timwid[] = {    /* width data in timtab */
	   21,   15,   23,   26,   25,   29,   30,   13,   19,   19,
	   21,   31,   13,   31,   13,   27,   25,   25,   25,   25,
	   25,   25,   25,   25,   25,   25,   13,   13,   29,   31,
	   29,   23,   32,   25,   27,   26,   27,   26,   25,   28,
	   29,   16,   20,   27,   23,   32,   28,   27,   27,   27,
	   27,   25,   24,   29,   25,   29,   25,   26,   25,   19,
	   19,   19,   27,   25,   17,   25,   26,   24,   26,   24,
	   18,   24,   27,   16,   16,   26,   16,   36,   27,   25,
	   26,   25,   22,   22,   20,   27,   23,   29,   25,   24,
	   23,   19,   13,   19,   29,   21 
};

/* Stroke data. */
short	timtab[] = {    /* stroke data in timtab */
	   35,    0,  220, 4250, 4302, 4378, 4316,  218, 4308,  201,
	 4232, 4295, 4360, 4297,    0,  220, 4251, 4245,  219, 4245,
	  220, 4379, 4245,  796, 4827, 4821,  795, 4821,  796, 4955,
	 4821,    0,  608, 4224,  992, 4608,  147, 5139,   77, 5069,
	    0,  416, 4483,  672, 4739,  921, 4952, 5015, 5080, 5081,
	 4955, 4764, 4508, 4315, 4185, 4183, 4245, 4308, 4435, 4817,
	 4944, 5070,   87, 4309, 4436, 4818, 4945, 5008, 5070, 5066,
	 4936, 4743, 4487, 4296, 4170, 4171, 4236, 4299, 4234,    0,
	 1244, 4167,  412, 4634, 4632, 4566, 4437, 4309, 4183, 4185,
	 4251, 4380, 4508, 4635, 4826, 5018, 5211, 5340,  974, 4941,
	 4875, 4873, 4999, 5127, 5256, 5322, 5324, 5198, 5070,    0,
	 1236, 5267, 5330, 5395, 5396, 5333, 5269, 5204, 5138, 5005,
	 4874, 4744, 4615, 4423, 4232, 4170, 4173, 4239, 4627, 4757,
	 4823, 4825, 4763, 4636, 4507, 4441, 4439, 4500, 4625, 4938,
	 5064, 5255, 5319, 5384, 5385,  327, 4296, 4234, 4237, 4303,
	 4433,  343, 4501, 5002, 5128, 5255,    0,  156, 4181,  220,
	 4181,    0,  608, 4574, 4443, 4311, 4242, 4238, 4297, 4421,
	 4546, 4672,  478, 4442, 4375, 4306, 4302, 4361, 4422, 4546,
	    0,   96, 4318, 4443, 4567, 4626, 4622, 4553, 4421, 4290,
	 4160,  222, 4442, 4503, 4562, 4558, 4489, 4422, 4290,    0,
	  406, 4490,   83, 4813,  723, 4173,    0,  729, 4807,  144,
	 5392,    0,  203, 4234, 4171, 4236, 4299, 4297, 4167,    0,
	  144, 5392,    0,  140, 4171, 4234, 4299, 4236,    0, 1184,
	 4096,    0,  476, 4379, 4248, 4179, 4176, 4235, 4360, 4551,
	 4679, 4872, 5003, 5072, 5075, 5016, 4891, 4700, 4572,  476,
	 4443, 4378, 4312, 4243, 4240, 4299, 4361, 4424, 4551,  583,
	 4808, 4873, 4939, 5008, 5011, 4952, 4890, 4827, 4700,    0,
	  280, 4505, 4700, 4679,  539, 4615,  263, 4935,    0,  152,
	 4311, 4246, 4183, 4184, 4250, 4315, 4508, 4764, 4955, 5018,
	 5080, 5078, 5012, 4818, 4496, 4367, 4237, 4170, 4167,  668,
	 4891, 4954, 5016, 5014, 4948, 4754, 4496,   73, 4234, 4362,
	 4680, 4872, 5001, 5066,  266, 4679, 4935, 5000, 5066, 5068,
	    0,  152, 4311, 4246, 4183, 4184, 4250, 4315, 4508, 4764,
	 4955, 5017, 5014, 4948, 4755, 4563,  668, 4891, 4953, 4950,
	 4884, 4755,  659, 4882, 5008, 5070, 5067, 5001, 4936, 4743,
	 4487, 4296, 4233, 4171, 4172, 4237, 4300, 4235,  849, 5006,
	 5003, 4937, 4872, 4743,    0,  666, 4743,  732, 4807,  732,
	 4109, 5133,  455, 4999,    0,  220, 4178,   82, 4308, 4501,
	 4693, 4884, 5010, 5071, 5069, 5002, 4872, 4679, 4487, 4296,
	 4233, 4171, 4172, 4237, 4300, 4235,  597, 4820, 4946, 5007,
	 5005, 4938, 4808, 4679,  220, 4956,  219, 4635, 4956,    0,
	  857, 4888, 4951, 5016, 5017, 4955, 4828, 4636, 4443, 4313,
	 4247, 4179, 4173, 4234, 4360, 4551, 4679, 4872, 5002, 5069,
	 5070, 5009, 4883, 4692, 4628, 4435, 4305, 4238,  540, 4507,
	 4377, 4311, 4243, 4237, 4298, 4424, 4551,  583, 4808, 4938,
	 5005, 5006, 4945, 4819, 4692,    0,   92, 4182,   88, 4250,
	 4380, 4508, 4825, 4953, 5018, 5084,  154, 4379, 4507, 4825,
	  988, 5081, 5014, 4753, 4687, 4620, 4615,  918, 4689, 4623,
	 4556, 4551,    0,  412, 4315, 4249, 4246, 4308, 4499, 4755,
	 4948, 5014, 5017, 4955, 4764, 4508,  412, 4379, 4313, 4310,
	 4372, 4499,  659, 4884, 4950, 4953, 4891, 4764,  403, 4306,
	 4241, 4175, 4171, 4233, 4296, 4487, 4743, 4936, 5001, 5067,
	 5071, 5009, 4946, 4755,  403, 4370, 4305, 4239, 4235, 4297,
	 4360, 4487,  647, 4872, 4937, 5003, 5007, 4945, 4882, 4755,
	    0,  917, 4946, 4816, 4623, 4559, 4368, 4242, 4181, 4182,
	 4249, 4379, 4572, 4700, 4891, 5017, 5078, 5072, 5004, 4938,
	 4808, 4615, 4423, 4296, 4234, 4235, 4300, 4363, 4298,  463,
	 4432, 4306, 4245, 4246, 4313, 4443, 4572,  604, 4827, 4953,
	 5014, 5008, 4940, 4874, 4744, 4615,    0,  147, 4178, 4241,
	 4306, 4243,  140, 4171, 4234, 4299, 4236,    0,  147, 4178,
	 4241, 4306, 4243,  203, 4234, 4171, 4236, 4299, 4297, 4167,
	    0, 1177, 4240, 5255,    0,  147, 5395,  141, 5389,    0,
	  153, 5264, 4231,    0,  152, 4311, 4246, 4183, 4184, 4250,
	 4315, 4444, 4636, 4827, 4890, 4952, 4950, 4884, 4819, 4561,
	 4558,  540, 4763, 4826, 4888, 4886, 4820, 4690,  457, 4488,
	 4551, 4616, 4553,    0, 1044, 5078, 4951, 4759, 4630, 4565,
	 4498, 4495, 4557, 4684, 4876, 5005, 5071,  663, 4629, 4562,
	 4559, 4621, 4684, 1047, 5071, 5069, 5196, 5324, 5454, 5521,
	 5523, 5462, 5400, 5274, 5147, 4956, 4764, 4571, 4442, 4312,
	 4246, 4179, 4176, 4237, 4299, 4425, 4552, 4743, 4935, 5128,
	 5257, 5322, 1111, 5135, 5133, 5196,    0,  540, 4167,  540,
	 5063,  537, 4999,  205, 4877,    7, 4423,  711, 5191,    0,
	  220, 4295,  284, 4359,   28, 4892, 5083, 5146, 5208, 5206,
	 5140, 5075, 4882,  796, 5019, 5082, 5144, 5142, 5076, 5011,
	 4882,  274, 4882, 5073, 5136, 5198, 5195, 5129, 5064, 4871,
	 4103,  786, 5009, 5072, 5134, 5131, 5065, 5000, 4871,    0,
	  985, 5142, 5148, 5081, 4955, 4764, 4636, 4443, 4313, 4247,
	 4180, 4175, 4236, 4298, 4424, 4615, 4743, 4936, 5066, 5132,
	  540, 4507, 4377, 4311, 4244, 4239, 4300, 4362, 4488, 4615,
	    0,  220, 4295,  284, 4359,   28, 4764, 4955, 5081, 5143,
	 5204, 5199, 5132, 5066, 4936, 4743, 4103,  668, 4891, 5017,
	 5079, 5140, 5135, 5068, 5002, 4872, 4743,    0,  220, 4295,
	  284, 4359,  662, 4750,   28, 5148, 5142, 5084,  274, 4754,
	    7, 5127, 5133, 5063,    0,  220, 4295,  284, 4359,  662,
	 4750,   28, 5148, 5142, 5084,  274, 4754,    7, 4551,    0,
	  985, 5142, 5148, 5081, 4955, 4764, 4636, 4443, 4313, 4247,
	 4180, 4175, 4236, 4298, 4424, 4615, 4743, 4936, 5066,  540,
	 4507, 4377, 4311, 4244, 4239, 4300, 4362, 4488, 4615,  975,
	 5063, 1039, 5127,  783, 5327,    0,  220, 4295,  284, 4359,
	 1052, 5127, 1116, 5191,   28, 4572,  860, 5404,  274, 5138,
	    7, 4551,  839, 5383,    0,  220, 4295,  284, 4359,   28,
	 4572,    7, 4551,    0,  540, 4619, 4552, 4423, 4295, 4168,
	 4106, 4108, 4173, 4236, 4171,  476, 4555, 4488, 4423,  284,
	 4828,    0,  220, 4295,  284, 4359, 1116, 4367,  595, 5191,
	  531, 5127,   28, 4572,  860, 5340,    7, 4551,  839, 5319,
	    0,  220, 4295,  284, 4359,   28, 4572,    7, 5063, 5069,
	 4999,    0,  220, 4295,  284, 4746,  220, 4743, 1116, 4743,
	 1116, 5191, 1180, 5255,   28, 4380, 1116, 5468,    7, 4487,
	  903, 5447,    0,  220, 4295,  284, 5129,  282, 5127, 1052,
	 5127,   28, 4380,  860, 5340,    7, 4487,    0,  540, 4443,
	 4313, 4247, 4179, 4176, 4236, 4298, 4424, 4615, 4743, 4936,
	 5066, 5132, 5200, 5203, 5143, 5081, 4955, 4764, 4636,  540,
	 4507, 4377, 4311, 4243, 4240, 4300, 4362, 4488, 4615,  647,
	 4872, 5002, 5068, 5136, 5139, 5079, 5017, 4891, 4764,    0,
	  220, 4295,  284, 4359,   28, 4892, 5083, 5146, 5208, 5205,
	 5139, 5074, 4881, 4369,  796, 5019, 5082, 5144, 5141, 5075,
	 5010, 4881,    7, 4551,    0,  540, 4443, 4313, 4247, 4179,
	 4176, 4236, 4298, 4424, 4615, 4743, 4936, 5066, 5132, 5200,
	 5203, 5143, 5081, 4955, 4764, 4636,  540, 4507, 4377, 4311,
	 4243, 4240, 4300, 4362, 4488, 4615,  647, 4872, 5002, 5068,
	 5136, 5139, 5079, 5017, 4891, 4764,  329, 4426, 4492, 4621,
	 4685, 4812, 4874, 4931, 4994, 5122, 5188, 5189,  778, 4934,
	 4996, 5059, 5123, 5188,    0,  220, 4295,  284, 4359,   28,
	 4892, 5083, 5146, 5208, 5206, 5140, 5075, 4882, 4370,  796,
	 5019, 5082, 5144, 5142, 5076, 5011, 4882,    7, 4551,  594,
	 4817, 4880, 5065, 5128, 5192, 5257,  721, 4879, 5000, 5063,
	 5191, 5257, 5258,    0,  921, 5084, 5078, 5017, 4891, 4700,
	 4508, 4315, 4185, 4183, 4245, 4308, 4435, 4817, 4944, 5070,
	   87, 4309, 4436, 4818, 4945, 5008, 5070, 5066, 4936, 4743,
	 4551, 4360, 4234, 4173, 4167, 4234,    0,  476, 4551,  540,
	 4615,   92, 4118, 4124, 5084, 5078, 5020,  263, 4807,    0,
	  220, 4301, 4362, 4488, 4679, 4807, 5000, 5130, 5197, 5212,
	  284, 4365, 4426, 4552, 4679,   28, 4572,  924, 5404,    0,
	   92, 4615,  156, 4618,  988, 4615,   28, 4444,  732, 5212,
	    0,  156, 4487,  220, 4492,  668, 4487,  668, 4999,  732,
	 5004, 1180, 4999,   28, 4508,  988, 5468,    0,   92, 4999,
	  156, 5063,  988, 4167,   28, 4444,  732, 5212,    7, 4423,
	  711, 5191,    0,   92, 4625, 4615,  156, 4689, 4679, 1052,
	 4689,   28, 4444,  796, 5276,  327, 4871,    0,  924, 4167,
	  988, 4231,  156, 4182, 4188, 5084,   71, 5063, 5069, 4999,
	    0,  160, 4224,  224, 4288,  160, 4704,  128, 4672,    0,
	   28, 4868,    0,  480, 4544,  544, 4608,   96, 4640,   64,
	 4608,    0,   78, 4691, 5198,   78, 4690, 5198,    0,    0,
	 5248,    0,  156, 4566,  156, 4187, 4566,    0,  211, 4306,
	 4242, 4243, 4308, 4437, 4693, 4820, 4883, 4945, 4938, 5000,
	 5063,  787, 4874, 4936, 5063, 5127,  785, 4816, 4431, 4238,
	 4172, 4170, 4232, 4423, 4615, 4744, 4874,  335, 4302, 4236,
	 4234, 4296, 4423,    0,  220, 4295,  284, 4359,  274, 4500,
	 4629, 4757, 4948, 5074, 5135, 5133, 5066, 4936, 4743, 4615,
	 4488, 4362,  661, 4884, 5010, 5071, 5069, 5002, 4872, 4743,
	   28, 4380,    0,  850, 4881, 4944, 5009, 5010, 4884, 4757,
	 4565, 4372, 4242, 4175, 4173, 4234, 4360, 4551, 4679, 4872,
	 5002,  469, 4436, 4306, 4239, 4237, 4298, 4424, 4551,    0,
	  860, 4935,  924, 4999,  850, 4820, 4693, 4565, 4372, 4242,
	 4175, 4173, 4234, 4360, 4551, 4679, 4808, 4938,  469, 4436,
	 4306, 4239, 4237, 4298, 4424, 4551,  668, 5020,  839, 5191,
	    0,  143, 5007, 5009, 4947, 4884, 4757, 4565, 4372, 4242,
	 4175, 4173, 4234, 4360, 4551, 4679, 4872, 5002,  847, 4946,
	 4884,  469, 4436, 4306, 4239, 4237, 4298, 4424, 4551,    0,
	  539, 4570, 4633, 4698, 4699, 4636, 4508, 4379, 4313, 4295,
	  412, 4443, 4377, 4359,   21, 4629,    7, 4551,    0,  405,
	 4372, 4307, 4241, 4239, 4301, 4364, 4491, 4619, 4748, 4813,
	 4879, 4881, 4819, 4756, 4629, 4501,  276, 4306, 4302, 4364,
	  652, 4814, 4818, 4756,  723, 4884, 5013, 5012, 4884,  205,
	 4236, 4170, 4169, 4231, 4422, 4742, 4933, 4996,   73, 4232,
	 4423, 4743, 4934, 4996, 4995, 4929, 4736, 4352, 4161, 4099,
	 4100, 4166, 4359,    0,  220, 4295,  284, 4359,  274, 4500,
	 4693, 4821, 5012, 5074, 5063,  725, 4948, 5010, 4999,   28,
	 4380,    7, 4551,  711, 5255,    0,  220, 4251, 4314, 4379,
	 4316,  213, 4295,  277, 4359,   21, 4373,    7, 4551,    0,
	  284, 4315, 4378, 4443, 4380,  341, 4419, 4353, 4224, 4096,
	 4097, 4098, 4099, 4162, 4097,  277, 4355, 4289, 4224,   85,
	 4437,    0,  220, 4295,  284, 4359,  917, 4363,  591, 5063,
	  527, 4999,   28, 4380,  725, 5205,    7, 4551,  711, 5191,
	    0,  220, 4295,  284, 4359,   28, 4380,    7, 4551,    0,
	  213, 4295,  277, 4359,  274, 4500, 4693, 4821, 5012, 5074,
	 5063,  725, 4948, 5010, 4999,  978, 5204, 5397, 5525, 5716,
	 5778, 5767, 1429, 5652, 5714, 5703,   21, 4373,    7, 4551,
	  711, 5255, 1415, 5959,    0,  213, 4295,  277, 4359,  274,
	 4500, 4693, 4821, 5012, 5074, 5063,  725, 4948, 5010, 4999,
	   21, 4373,    7, 4551,  711, 5255,    0,  469, 4372, 4242,
	 4175, 4173, 4234, 4360, 4551, 4679, 4872, 5002, 5069, 5071,
	 5010, 4884, 4693, 4565,  469, 4436, 4306, 4239, 4237, 4298,
	 4424, 4551,  583, 4808, 4938, 5005, 5007, 4946, 4820, 4693,
	    0,  213, 4288,  277, 4352,  274, 4500, 4629, 4757, 4948,
	 5074, 5135, 5133, 5066, 4936, 4743, 4615, 4488, 4362,  661,
	 4884, 5010, 5071, 5069, 5002, 4872, 4743,   21, 4373,    0,
	 4544,    0,  853, 4928,  917, 4992,  850, 4820, 4693, 4565,
	 4372, 4242, 4175, 4173, 4234, 4360, 4551, 4679, 4808, 4938,
	  469, 4436, 4306, 4239, 4237, 4298, 4424, 4551,  640, 5184,
	    0,  213, 4295,  277, 4359,  271, 4434, 4564, 4693, 4885,
	 4948, 4947, 4882, 4819, 4884,   21, 4373,    7, 4551,    0,
	  723, 4885, 4881, 4819, 4756, 4629, 4373, 4244, 4179, 4177,
	 4240, 4367, 4685, 4812, 4875,   82, 4241, 4368, 4686, 4813,
	 4876, 4873, 4808, 4679, 4423, 4296, 4233, 4171, 4167, 4233,
	    0,  220, 4299, 4360, 4487, 4615, 4744, 4810,  284, 4363,
	 4424, 4487,   21, 4629,    0,  213, 4298, 4360, 4551, 4679,
	 4872, 5002,  277, 4362, 4424, 4551,  917, 4999,  981, 5063,
	   21, 4373,  725, 5077,  903, 5255,    0,   85, 4551,  149,
	 4553,  853, 4551,   21, 4437,  597, 5077,    0,  149, 4487,
	  213, 4490,  661, 4487,  661, 4999,  725, 5002, 1173, 4999,
	   21, 4501,  981, 5461,    0,  149, 4935,  213, 4999,  917,
	 4231,   21, 4501,  661, 5141,    7, 4487,  647, 5127,    0,
	  149, 4615,  213, 4617,  917, 4615, 4483, 4353, 4224, 4160,
	 4097, 4162, 4225,   21, 4501,  661, 5141,    0,  789, 4167,
	  853, 4231,  149, 4177, 4181, 4949,   71, 4935, 4939, 4871,
	    0,  480, 4447, 4382, 4316, 4314, 4376, 4439, 4501, 4499,
	 4369,  351, 4381, 4379, 4441, 4504, 4566, 4564, 4498, 4240,
	 4494, 4556, 4554, 4488, 4423, 4357, 4355, 4417,  271, 4493,
	 4491, 4425, 4360, 4294, 4292, 4354, 4417, 4544,    0,  160,
	 4224,    0,  224, 4447, 4510, 4572, 4570, 4504, 4439, 4373,
	 4371, 4497,  351, 4509, 4507, 4441, 4376, 4310, 4308, 4370,
	 4624, 4366, 4300, 4298, 4360, 4423, 4485, 4483, 4417,  399,
	 4365, 4363, 4425, 4488, 4550, 4548, 4482, 4417, 4288,    0,
	   77, 4175, 4242, 4371, 4499, 4626, 4879, 5006, 5134, 5263,
	 5329,   79, 4241, 4370, 4498, 4625, 4878, 5005, 5133, 5262,
	 5329, 5331,    0,   28, 4103, 4103, 4124, 4124, 4103, 4167,
	 4188, 4252, 4231, 4295, 4316, 4380, 4359, 4423, 4444, 4508,
	 4487, 4551, 4572, 4636, 4615, 4679, 4700, 4764, 4743, 4807,
	 4828, 4892, 4871, 4935, 4956, 5020, 4999,    0,
};


/* Futura Font Data */
short	futidx[] = {    /* character index in futtab */
	    1,    3,   11,   16,   25,   50,   80,  115,  123,  134,  145,  152,
	  157,  165,  168,  174,  177,  195,  200,  215,  231,  237,  255,  279,
	  284,  314,  338,  349,  362,  366,  371,  375,  395,  448,  455,  477,
	  496,  511,  520,  527,  549,  556,  559,  570,  577,  582,  591,  598,
	  620,  633,  657,  672,  693,  698,  709,  714,  723,  728,  734,  741,
	  750,  753,  762,  767,  770,  778,  795,  812,  827,  844,  862,  870,
	  892,  902,  910,  921,  928,  931,  948,  958,  976,  993, 1010, 1018,
	 1036, 1044, 1054, 1059, 1068, 1073, 1082, 1089, 1127, 1130, 1168, 1191,
};

/* Width data. */
short	futwid[] = {    /* width data in futtab */
	   21,   15,   21,   26,   25,   29,   31,   15,   19,   19,
	   21,   31,   13,   31,   13,   27,   25,   25,   25,   25,
	   25,   25,   25,   25,   25,   25,   13,   13,   29,   31,
	   29,   23,   32,   23,   26,   26,   26,   24,   23,   26,
	   27,   13,   21,   26,   22,   29,   27,   27,   26,   27,
	   26,   25,   21,   27,   23,   29,   25,   23,   25,   19,
	   19,   19,   21,   23,   13,   24,   24,   23,   24,   23,
	   17,   24,   24,   11,   15,   22,   13,   34,   24,   24,
	   24,   24,   20,   22,   17,   24,   21,   27,   22,   21,
	   22,   19,   13,   19,   29,   21 
};

/* Stroke data. */
short	futtab[] = {    /* stroke data in futtab */
	   35,    0,  220, 4302,  201, 4232, 4295, 4360, 4297,    0,
	  156, 4245,  668, 4757,    0,  608, 4224,  992, 4608,  147,
	 5139,   77, 5069,    0,  416, 4483,  672, 4739,  985, 4955,
	 4764, 4508, 4315, 4185, 4183, 4245, 4308, 4435, 4817, 4944,
	 5007, 5069, 5066, 4936, 4743, 4487, 4296, 4170,    0, 1244,
	 4167,  412, 4634, 4632, 4566, 4437, 4309, 4183, 4185, 4251,
	 4380, 4508, 4635, 4826, 5018, 5211, 5340,  974, 4941, 4875,
	 4873, 4999, 5127, 5256, 5322, 5324, 5198, 5070,    0, 1363,
	 5460, 5397, 5333, 5268, 5202, 5069, 4938, 4808, 4679, 4423,
	 4296, 4233, 4171, 4173, 4239, 4304, 4756, 4821, 4887, 4889,
	 4827, 4700, 4571, 4505, 4503, 4564, 4689, 5002, 5128, 5255,
	 5383, 5448, 5449,    0,  218, 4251, 4316, 4379, 4377, 4311,
	 4246,    0,  608, 4574, 4443, 4311, 4242, 4238, 4297, 4421,
	 4546, 4672,    0,   96, 4318, 4443, 4567, 4626, 4622, 4553,
	 4421, 4290, 4160,    0,  406, 4490,   83, 4813,  723, 4173,
	    0,  729, 4807,  144, 5392,    0,  203, 4234, 4171, 4236,
	 4299, 4297, 4167,    0,  144, 5392,    0,  140, 4171, 4234,
	 4299, 4236,    0, 1184, 4096,    0,  476, 4379, 4248, 4179,
	 4176, 4235, 4360, 4551, 4679, 4872, 5003, 5072, 5075, 5016,
	 4891, 4700, 4572,    0,  280, 4505, 4700, 4679,    0,  151,
	 4248, 4314, 4379, 4508, 4764, 4891, 4954, 5016, 5014, 4948,
	 4817, 4167, 5063,    0,  220, 5020, 4628, 4820, 4947, 5010,
	 5071, 5069, 5002, 4872, 4679, 4487, 4296, 4233, 4171,    0,
	  732, 4174, 5134,  732, 4807,    0,  860, 4316, 4243, 4308,
	 4501, 4693, 4884, 5010, 5071, 5069, 5002, 4872, 4679, 4487,
	 4296, 4233, 4171,    0,  921, 4955, 4764, 4636, 4443, 4312,
	 4243, 4238, 4298, 4424, 4615, 4679, 4872, 5002, 5069, 5070,
	 5009, 4883, 4692, 4628, 4435, 4305, 4238,    0,  988, 4423,
	   92, 5084,    0,  412, 4315, 4249, 4247, 4309, 4436, 4691,
	 4882, 5008, 5070, 5067, 5001, 4936, 4743, 4487, 4296, 4233,
	 4171, 4174, 4240, 4370, 4563, 4820, 4949, 5015, 5017, 4955,
	 4764, 4508,    0,  917, 4946, 4816, 4623, 4559, 4368, 4242,
	 4181, 4182, 4249, 4379, 4572, 4636, 4827, 4953, 5013, 5008,
	 4939, 4808, 4615, 4487, 4296, 4234,    0,  147, 4178, 4241,
	 4306, 4243,  140, 4171, 4234, 4299, 4236,    0,  147, 4178,
	 4241, 4306, 4243,  203, 4234, 4171, 4236, 4299, 4297, 4167,
	    0, 1177, 4240, 5255,    0,  147, 5395,  141, 5389,    0,
	  153, 5264, 4231,    0,   87, 4184, 4250, 4315, 4444, 4700,
	 4827, 4890, 4952, 4950, 4884, 4819, 4561, 4558,  457, 4488,
	 4551, 4616, 4553,    0, 1044, 5078, 4951, 4759, 4630, 4565,
	 4498, 4495, 4557, 4684, 4876, 5005, 5071,  663, 4629, 4562,
	 4559, 4621, 4684, 1047, 5071, 5069, 5196, 5324, 5454, 5521,
	 5523, 5462, 5400, 5274, 5147, 4956, 4764, 4571, 4442, 4312,
	 4246, 4179, 4176, 4237, 4299, 4425, 4552, 4743, 4935, 5128,
	 5257, 5322, 1111, 5135, 5133, 5196,    0,  476, 4103,  476,
	 5063,  142, 4878,    0,  156, 4231,  156, 4828, 5019, 5082,
	 5144, 5142, 5076, 5011, 4818,  146, 4818, 5009, 5072, 5134,
	 5131, 5065, 5000, 4807, 4231,    0, 1047, 5081, 4955, 4828,
	 4572, 4443, 4313, 4247, 4180, 4175, 4236, 4298, 4424, 4551,
	 4807, 4936, 5066, 5132,    0,  156, 4231,  156, 4700, 4891,
	 5017, 5079, 5140, 5135, 5068, 5002, 4872, 4679, 4231,    0,
	  156, 4231,  156, 5084,  146, 4754,  135, 5063,    0,  156,
	 4231,  156, 5084,  146, 4754,    0, 1047, 5081, 4955, 4828,
	 4572, 4443, 4313, 4247, 4180, 4175, 4236, 4298, 4424, 4551,
	 4807, 4936, 5066, 5132, 5135,  719, 5135,    0,  156, 4231,
	 1052, 5127,  146, 5138,    0,  156, 4231,    0,  668, 4748,
	 4681, 4616, 4487, 4359, 4232, 4169, 4108, 4110,    0,  156,
	 4231, 1052, 4238,  467, 5127,    0,  156, 4231,  135, 4999,
	    0,  156, 4231,  156, 4743, 1180, 4743, 1180, 5255,    0,
	  156, 4231,  156, 5127, 1052, 5127,    0,  476, 4443, 4313,
	 4247, 4180, 4175, 4236, 4298, 4424, 4551, 4807, 4936, 5066,
	 5132, 5199, 5204, 5143, 5081, 4955, 4828, 4572,    0,  156,
	 4231,  156, 4828, 5019, 5082, 5144, 5141, 5075, 5010, 4817,
	 4241,    0,  476, 4443, 4313, 4247, 4180, 4175, 4236, 4298,
	 4424, 4551, 4807, 4936, 5066, 5132, 5199, 5204, 5143, 5081,
	 4955, 4828, 4572,  651, 5125,    0,  156, 4231,  156, 4828,
	 5019, 5082, 5144, 5142, 5076, 5011, 4818, 4242,  594, 5127,
	    0,  985, 4955, 4764, 4508, 4315, 4185, 4183, 4245, 4308,
	 4435, 4817, 4944, 5007, 5069, 5066, 4936, 4743, 4487, 4296,
	 4170,    0,  412, 4487,   28, 4956,    0,  156, 4237, 4298,
	 4424, 4615, 4743, 4936, 5066, 5133, 5148,    0,   28, 4551,
	  988, 4551,    0,   28, 4423,  668, 4423,  668, 5063, 1308,
	 5063,    0,   92, 5063,  988, 4167,    0,   28, 4562, 4551,
	  988, 4562,    0,  988, 4167,   92, 5084,   71, 5063,    0,
	  160, 4224,  224, 4288,  160, 4704,  128, 4672,    0,   28,
	 4868,    0,  480, 4544,  544, 4608,   96, 4640,   64, 4608,
	    0,  414, 4112,  414, 5008,    0,    0, 5120,    0,  215,
	 4181, 4179, 4242, 4307, 4244, 4179,    0,  853, 4935,  850,
	 4820, 4693, 4501, 4372, 4242, 4175, 4173, 4234, 4360, 4487,
	 4679, 4808, 4938,    0,  156, 4231,  146, 4372, 4501, 4693,
	 4820, 4946, 5007, 5005, 4938, 4808, 4679, 4487, 4360, 4234,
	    0,  850, 4820, 4693, 4501, 4372, 4242, 4175, 4173, 4234,
	 4360, 4487, 4679, 4808, 4938,    0,  860, 4935,  850, 4820,
	 4693, 4501, 4372, 4242, 4175, 4173, 4234, 4360, 4487, 4679,
	 4808, 4938,    0,   79, 4943, 4945, 4883, 4820, 4693, 4501,
	 4372, 4242, 4175, 4173, 4234, 4360, 4487, 4679, 4808, 4938,
	    0,  540, 4508, 4379, 4312, 4295,   21, 4565,    0,  853,
	 4933, 4866, 4801, 4672, 4480, 4353,  850, 4820, 4693, 4501,
	 4372, 4242, 4175, 4173, 4234, 4360, 4487, 4679, 4808, 4938,
	    0,  156, 4231,  145, 4436, 4565, 4757, 4884, 4945, 4935,
	    0,   92, 4251, 4316, 4253, 4188,  149, 4231,    0,  220,
	 4379, 4444, 4381, 4316,  277, 4356, 4289, 4160, 4096,    0,
	  156, 4231,  789, 4235,  399, 4935,    0,  156, 4231,    0,
	  149, 4231,  145, 4436, 4565, 4757, 4884, 4945, 4935,  849,
	 5140, 5269, 5461, 5588, 5649, 5639,    0,  149, 4231,  145,
	 4436, 4565, 4757, 4884, 4945, 4935,    0,  405, 4372, 4242,
	 4175, 4173, 4234, 4360, 4487, 4679, 4808, 4938, 5005, 5007,
	 4946, 4820, 4693, 4501,    0,  149, 4224,  146, 4372, 4501,
	 4693, 4820, 4946, 5007, 5005, 4938, 4808, 4679, 4487, 4360,
	 4234,    0,  853, 4928,  850, 4820, 4693, 4501, 4372, 4242,
	 4175, 4173, 4234, 4360, 4487, 4679, 4808, 4938,    0,  149,
	 4231,  143, 4306, 4436, 4565, 4757,    0,  786, 4820, 4629,
	 4437, 4244, 4178, 4240, 4367, 4686, 4813, 4875, 4874, 4808,
	 4615, 4423, 4232, 4170,    0,  220, 4299, 4360, 4487, 4615,
	   21, 4565,    0,  149, 4235, 4296, 4423, 4615, 4744, 4939,
	  853, 4935,    0,   21, 4487,  789, 4487,    0,   85, 4423,
	  597, 4423,  597, 4935, 1109, 4935,    0,   85, 4871,  789,
	 4167,    0,   21, 4487,  789, 4487, 4355, 4225, 4096, 4096,
	    0,  789, 4167,   85, 4885,   71, 4871,    0,  480, 4447,
	 4382, 4316, 4314, 4376, 4439, 4501, 4499, 4369,  351, 4381,
	 4379, 4441, 4504, 4566, 4564, 4498, 4240, 4494, 4556, 4554,
	 4488, 4423, 4357, 4355, 4417,  271, 4493, 4491, 4425, 4360,
	 4294, 4292, 4354, 4417, 4544,    0,  160, 4224,    0,  224,
	 4447, 4510, 4572, 4570, 4504, 4439, 4373, 4371, 4497,  351,
	 4509, 4507, 4441, 4376, 4310, 4308, 4370, 4624, 4366, 4300,
	 4298, 4360, 4423, 4485, 4483, 4417,  399, 4365, 4363, 4425,
	 4488, 4550, 4548, 4482, 4417, 4288,    0,   77, 4175, 4242,
	 4371, 4499, 4626, 4879, 5006, 5134, 5263, 5329,   79, 4241,
	 4370, 4498, 4625, 4878, 5005, 5133, 5262, 5329, 5331,    0,
	   28, 4103, 4103, 4124, 4124, 4103, 4167, 4188, 4252, 4231,
	 4295, 4316, 4380, 4359, 4423, 4444, 4508, 4487, 4551, 4572,
	 4636, 4615, 4679, 4700, 4764, 4743, 4807, 4828, 4892, 4871,
	 4935, 4956, 5020, 4999,    0,
};
