/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc;

import helma.xmlrpc.Base64;
import helma.xmlrpc.XmlRpc;
import helma.xmlrpc.XmlRpcException;
import helma.xmlrpc.XmlRpcHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class XmlRpcClient
implements XmlRpcHandler {
    URL url;
    String auth;
    Stack pool = new Stack();
    int workers = 0;

    public XmlRpcClient(String string) throws MalformedURLException {
        this.url = new URL(string);
    }

    public XmlRpcClient(String string, int n) throws MalformedURLException {
        this.url = new URL("http://" + string + ":" + n + "/RPC2");
    }

    public XmlRpcClient(URL uRL) {
        this.url = uRL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(String string, Vector vector) throws XmlRpcException, IOException {
        Object object;
        block3: {
            Worker worker = this.getWorker();
            try {
                Object object2;
                object = object2 = worker.execute(string, vector);
                Object var6_6 = null;
                if (this.workers >= 50 || worker.fault) break block3;
                this.pool.push(worker);
                return object;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.workers < 50 && !worker.fault) {
                    this.pool.push(worker);
                    throw throwable;
                }
                --this.workers;
                throw throwable;
            }
        }
        --this.workers;
        return object;
    }

    private final Worker getWorker() throws IOException {
        try {
            return (Worker)this.pool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            if (this.workers < 100) {
                ++this.workers;
                return new Worker();
            }
            throw new IOException("XML-RPC System overload");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            Vector<Object> vector = new Vector<Object>();
            int n = 2;
            while (n < stringArray.length) {
                try {
                    vector.addElement(new Integer(Integer.parseInt(stringArray[n])));
                }
                catch (NumberFormatException numberFormatException) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
            XmlRpcClient xmlRpcClient = new XmlRpcClient(string);
            try {
                System.err.println(xmlRpcClient.execute(string2, vector));
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Usage: java helma.xmlrpc.XmlRpcClient <url> <method> <arg> ....");
            System.err.println("Arguments are sent as integers or strings.");
        }
    }

    public void setBasicAuthentication(String string, String string2) {
        if (string == null || string2 == null) {
            this.auth = null;
        } else {
            char[] cArray = Base64.encode((String.valueOf(string) + ":" + string2).getBytes());
            this.auth = new String(cArray).trim();
        }
    }

    class Worker
    extends XmlRpc {
        boolean fault;
        Object result = null;
        StringBuffer strbuf;

        public Object execute(String string, Vector vector) throws XmlRpcException, IOException {
            Object object;
            Object object2;
            Object object3;
            this.fault = false;
            long l = System.currentTimeMillis();
            try {
                object3 = new ByteArrayOutputStream();
                if (this.strbuf == null) {
                    this.strbuf = new StringBuffer();
                } else {
                    this.strbuf.setLength(0);
                }
                Worker worker = this;
                worker.getClass();
                object2 = worker.new XmlRpc.XmlWriter(this.strbuf);
                this.writeRequest((XmlRpc.XmlWriter)object2, string, vector);
                object = ((XmlRpc.XmlWriter)object2).getBytes();
                URLConnection uRLConnection = XmlRpcClient.this.url.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.setDoOutput(true);
                uRLConnection.setUseCaches(false);
                uRLConnection.setAllowUserInteraction(false);
                uRLConnection.setRequestProperty("Content-Length", Integer.toString(((byte[])object).length));
                uRLConnection.setRequestProperty("Content-Type", "text/xml");
                if (XmlRpcClient.this.auth != null) {
                    uRLConnection.setRequestProperty("Authorization", "Basic " + XmlRpcClient.this.auth);
                }
                OutputStream outputStream = uRLConnection.getOutputStream();
                outputStream.write((byte[])object);
                outputStream.flush();
                InputStream inputStream = uRLConnection.getInputStream();
                this.parse(inputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception.getMessage());
            }
            if (this.fault) {
                object3 = null;
                try {
                    object2 = (Hashtable)this.result;
                    object = (String)((Hashtable)object2).get("faultString");
                    int n = Integer.parseInt(((Hashtable)object2).get("faultCode").toString());
                    object3 = new XmlRpcException(n, ((String)object).trim());
                }
                catch (Exception exception) {
                    throw new XmlRpcException(0, "Invalid fault response");
                }
                throw object3;
            }
            if (XmlRpc.debug) {
                System.err.println("Spent " + (System.currentTimeMillis() - l) + " in request");
            }
            return this.result;
        }

        void objectParsed(Object object) {
            this.result = object;
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            if ("fault".equals(string)) {
                this.fault = true;
            } else {
                super.startElement(string, attributeList);
            }
        }

        void writeRequest(XmlRpc.XmlWriter xmlWriter, String string, Vector vector) throws IOException {
            xmlWriter.startElement("methodCall");
            xmlWriter.startElement("methodName");
            xmlWriter.write(string);
            xmlWriter.endElement("methodName");
            xmlWriter.startElement("params");
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                xmlWriter.startElement("param");
                this.writeObject(vector.elementAt(n2), xmlWriter);
                xmlWriter.endElement("param");
                ++n2;
            }
            xmlWriter.endElement("params");
            xmlWriter.endElement("methodCall");
        }
    }
}

