/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;

public class Ejbc
extends MatchingTask {
    private File descriptorDirectory;
    private File generatedFilesDirectory;
    private File generatedManifestFile;
    private String classpath;
    private File sourceDirectory;

    public void execute() throws BuildException {
        if (this.descriptorDirectory == null || !this.descriptorDirectory.isDirectory()) {
            throw new BuildException("descriptors directory " + this.descriptorDirectory.getPath() + " is not valid");
        }
        if (this.generatedFilesDirectory == null || !this.generatedFilesDirectory.isDirectory()) {
            throw new BuildException("dest directory " + this.generatedFilesDirectory.getPath() + " is not valid");
        }
        if (this.sourceDirectory == null || !this.sourceDirectory.isDirectory()) {
            throw new BuildException("src directory " + this.sourceDirectory.getPath() + " is not valid");
        }
        String systemClassPath = System.getProperty("java.class.path");
        String execClassPath = Project.translatePath((String)(String.valueOf(systemClassPath) + ":" + this.classpath + ":" + this.generatedFilesDirectory));
        DirectoryScanner ds = super.getDirectoryScanner(this.descriptorDirectory);
        String[] files = ds.getIncludedFiles();
        Java helperTask = (Java)((Task)this).project.createTask("java");
        helperTask.setFork(true);
        helperTask.setClassname("org.apache.tools.ant.taskdefs.optional.ejb.EjbcHelper");
        String args = "";
        args = String.valueOf(args) + " " + this.descriptorDirectory;
        args = String.valueOf(args) + " " + this.generatedFilesDirectory;
        args = String.valueOf(args) + " " + this.sourceDirectory;
        args = String.valueOf(args) + " " + this.generatedManifestFile;
        int i = 0;
        while (i < files.length) {
            args = String.valueOf(args) + " " + files[i];
            ++i;
        }
        helperTask.setArgs(args);
        helperTask.setClasspath(new Path(((Task)this).project, execClassPath));
        if (helperTask.executeJava() != 0) {
            throw new BuildException("Execution of ejbc helper failed");
        }
    }

    public void setClasspath(String s) {
        this.classpath = Project.translatePath((String)s);
    }

    public void setDescriptors(String dirName) {
        this.descriptorDirectory = new File(dirName);
    }

    public void setDest(String dirName) {
        this.generatedFilesDirectory = new File(dirName);
    }

    public void setManifest(String manifestFilename) {
        this.generatedManifestFile = new File(manifestFilename);
    }

    public void setSrc(String dirName) {
        this.sourceDirectory = new File(dirName);
    }
}

