/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.util.Enumeration;
import org.apache.ecs.Attributes;
import org.apache.ecs.ECSDefaults;
import org.apache.ecs.Element;
import org.apache.ecs.Filter;
import org.apache.ecs.GenericElement;

public abstract class ElementAttributes
extends GenericElement
implements Attributes {
    private Filter attribute_filter = this.getFilter();
    private boolean filter_attribute_state = ECSDefaults.getDefaultFilterAttributeState();
    private char attribute_equality_sign = ECSDefaults.getDefaultAttributeEqualitySign();
    private char attribute_quote_char = ECSDefaults.getDefaultAttributeQuoteChar();
    private boolean attribute_quote = ECSDefaults.getDefaultAttributeQuote();

    public Element addAttribute(String string, int n) {
        this.getElementHashEntry().put(string, new Integer(n));
        return this;
    }

    public Element addAttribute(String string, Integer n) {
        this.getElementHashEntry().put(string, n);
        return this;
    }

    public Element addAttribute(String string, Object object2) {
        this.getElementHashEntry().put(string, object2);
        return this;
    }

    public Element addAttribute(String string, String string2) {
        this.getElementHashEntry().put(string, string2);
        return this;
    }

    public Enumeration attributes() {
        return this.getElementHashEntry().keys();
    }

    protected String createStartTag() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartTagChar());
        if (this.getBeginStartModifierDefined()) {
            stringBuffer.append(this.getBeginStartModifier());
        }
        stringBuffer.append(this.getElementType());
        Enumeration enumeration = this.getElementHashEntry().keys();
        String string = null;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = this.getAttributeFilterState() ? this.getAttributeFilter().process(this.getElementHashEntry().get(string2).toString()) : (String)this.getElementHashEntry().get(string2);
            stringBuffer.append(' ');
            stringBuffer.append(this.alterCase(string2));
            if (!string.equalsIgnoreCase("ECS_NO_ATTRIBUTE_VALUE") && this.getAttributeQuote()) {
                stringBuffer.append(this.getAttributeEqualitySign());
                stringBuffer.append(this.getAttributeQuoteChar());
                stringBuffer.append(string);
                stringBuffer.append(this.getAttributeQuoteChar());
                continue;
            }
            if (this.getAttributeQuote()) continue;
            stringBuffer.append(this.getAttributeEqualitySign());
            stringBuffer.append(string);
        }
        if (this.getBeginEndModifierDefined()) {
            stringBuffer.append(this.getBeginEndModifier());
        }
        stringBuffer.append(this.getEndTagChar());
        return stringBuffer.toString();
    }

    public String getAttribute(String string) {
        return (String)this.getElementHashEntry().get(string);
    }

    public char getAttributeEqualitySign() {
        return this.attribute_equality_sign;
    }

    public Filter getAttributeFilter() {
        return this.attribute_filter;
    }

    protected boolean getAttributeFilterState() {
        return this.filter_attribute_state;
    }

    public boolean getAttributeQuote() {
        return this.attribute_quote;
    }

    public char getAttributeQuoteChar() {
        return this.attribute_quote_char;
    }

    public boolean hasAttribute(String string) {
        return this.getElementHashEntry().containsKey(string);
    }

    public Element removeAttribute(String string) {
        try {
            this.getElementHashEntry().remove(string);
        }
        catch (Exception exception) {}
        return this;
    }

    public Element setAttributeEqualitySign(char c) {
        this.attribute_equality_sign = c;
        return this;
    }

    public Element setAttributeFilter(Filter filter) {
        this.filter_attribute_state = true;
        this.attribute_filter = filter;
        return this;
    }

    public Element setAttributeFilterState(boolean bl) {
        this.filter_attribute_state = bl;
        return this;
    }

    public Element setAttributeQuote(boolean bl) {
        this.attribute_quote = bl;
        return this;
    }

    public Element setAttributeQuoteChar(char c) {
        this.attribute_quote_char = c;
        return this;
    }

    public Element setClass(String string) {
        this.addAttribute("class", string);
        return this;
    }

    public Element setDir(String string) {
        this.addAttribute("dir", string);
        return this;
    }

    public Element setID(String string) {
        this.addAttribute("id", string);
        return this;
    }

    public Element setLang(String string) {
        this.addAttribute("lang", string);
        return this;
    }

    public Element setStyle(String string) {
        this.addAttribute("style", string);
        return this;
    }

    public Element setTitle(String string) {
        this.addAttribute("title", string);
        return this;
    }
}

