/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.ecs.ECSDefaults;
import org.apache.ecs.Element;
import org.apache.ecs.ElementAttributes;
import org.apache.ecs.GenericElement;
import org.apache.ecs.Printable;
import org.apache.ecs.StringElement;

public class ConcreteElement
extends ElementAttributes
implements Cloneable {
    private Hashtable registry = new Hashtable(4);
    private Vector registryList = new Vector(2);

    public Element addElementToRegistry(String string) {
        if (string == null) {
            return this;
        }
        this.addElementToRegistry(new StringElement(string));
        return this;
    }

    public Element addElementToRegistry(String string, String string2) {
        if (string == null) {
            return this;
        }
        StringElement stringElement = new StringElement(string2);
        stringElement.setFilterState(this.getFilterState());
        stringElement.setFilter(this.getFilter());
        stringElement.setPrettyPrint(this.getPrettyPrint());
        this.addElementToRegistry(string, stringElement);
        return this;
    }

    public Element addElementToRegistry(String string, String string2, boolean bl) {
        if (string == null) {
            return this;
        }
        this.setFilterState(bl);
        this.addElementToRegistry(string, string2);
        return this;
    }

    public Element addElementToRegistry(String string, Element element) {
        if (string == null || element == null) {
            return this;
        }
        element.setFilterState(this.getFilterState());
        if (ECSDefaults.getDefaultPrettyPrint() != element.getPrettyPrint()) {
            element.setPrettyPrint(this.getPrettyPrint());
        }
        this.registry.put(string, element);
        if (!this.registryList.contains(string)) {
            this.registryList.addElement(string);
        }
        return this;
    }

    public Element addElementToRegistry(String string, Element element, boolean bl) {
        if (string == null) {
            return this;
        }
        this.setFilterState(bl);
        this.addElementToRegistry(string, element);
        return this;
    }

    public Element addElementToRegistry(String string, boolean bl) {
        if (string == null) {
            return this;
        }
        this.setFilterState(bl);
        this.addElementToRegistry(Integer.toString(string.hashCode()), string);
        return this;
    }

    public Element addElementToRegistry(Element element) {
        if (element == null) {
            return this;
        }
        this.addElementToRegistry(Integer.toString(element.hashCode()), element);
        return this;
    }

    public Element addElementToRegistry(Element element, boolean bl) {
        if (element == null) {
            return this;
        }
        this.setFilterState(bl);
        this.addElementToRegistry(Integer.toString(element.hashCode()), element);
        return this;
    }

    public Object clone() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            return object2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError(classNotFoundException.toString());
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new InternalError(streamCorruptedException.toString());
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
    }

    public Enumeration elements() {
        return this.registry.elements();
    }

    public ConcreteElement getElement(String string) {
        if (this.registry.containsKey(string)) {
            return (ConcreteElement)this.registry.get(string);
        }
        return null;
    }

    public Enumeration keys() {
        return this.registryList.elements();
    }

    public void output(OutputStream outputStream) {
        boolean bl = this.getPrettyPrint();
        int n = this.getTabLevel();
        try {
            if (this.registry.size() == 0) {
                if (bl && this instanceof Printable && n > 0) {
                    this.putTabs(n, outputStream);
                }
                super.output(outputStream);
            } else {
                if (bl && this instanceof Printable && n > 0) {
                    this.putTabs(n, outputStream);
                }
                outputStream.write(this.createStartTag().getBytes());
                if (this.getTagText() != null) {
                    outputStream.write(this.getTagText().getBytes());
                }
                Enumeration enumeration = this.registryList.elements();
                while (enumeration.hasMoreElements()) {
                    Object object2;
                    Object v = this.registry.get((String)enumeration.nextElement());
                    if (v instanceof GenericElement) {
                        object2 = (Element)v;
                        if (bl && this instanceof Printable && this.getNeedLineBreak()) {
                            outputStream.write(10);
                            object2.setTabLevel(n + 1);
                        }
                        object2.output(outputStream);
                        continue;
                    }
                    if (bl && this instanceof Printable && this.getNeedLineBreak()) {
                        outputStream.write(10);
                        this.putTabs(n + 1, outputStream);
                    }
                    object2 = v.toString();
                    outputStream.write(((String)object2).getBytes());
                }
                if (this.getNeedClosingTag()) {
                    if (bl && this instanceof Printable && this.getNeedLineBreak()) {
                        outputStream.write(10);
                        if (n > 0) {
                            this.putTabs(n, outputStream);
                        }
                    }
                    outputStream.write(this.createEndTag().getBytes());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(new PrintWriter(outputStream));
        }
    }

    public void output(PrintWriter printWriter) {
        boolean bl = this.getPrettyPrint();
        int n = this.getTabLevel();
        if (this.registry.size() == 0) {
            if (bl && this instanceof Printable && n > 0) {
                this.putTabs(n, printWriter);
            }
            super.output(printWriter);
        } else {
            if (bl && this instanceof Printable && n > 0) {
                this.putTabs(n, printWriter);
            }
            printWriter.write(this.createStartTag());
            if (this.getTagText() != null) {
                printWriter.write(this.getTagText());
            }
            Enumeration enumeration = this.registryList.elements();
            while (enumeration.hasMoreElements()) {
                Object object2;
                Object v = this.registry.get((String)enumeration.nextElement());
                if (v instanceof GenericElement) {
                    object2 = (Element)v;
                    if (bl && this instanceof Printable && this.getNeedLineBreak()) {
                        printWriter.write(10);
                        object2.setTabLevel(n + 1);
                    }
                    object2.output(printWriter);
                    continue;
                }
                if (bl && this instanceof Printable && this.getNeedLineBreak()) {
                    printWriter.write(10);
                    this.putTabs(n + 1, printWriter);
                }
                object2 = v.toString();
                if (this.getFilterState()) {
                    printWriter.write(this.getFilter().process((String)object2));
                    continue;
                }
                printWriter.write((String)object2);
            }
            if (this.getNeedClosingTag()) {
                if (bl && this instanceof Printable && this.getNeedLineBreak()) {
                    printWriter.write(10);
                    if (n > 0) {
                        this.putTabs(n, printWriter);
                    }
                }
                printWriter.write(this.createEndTag());
            }
        }
    }

    public void output(Writer writer) {
        this.output(new PrintWriter(writer));
    }

    public boolean registryHasElement(String string) {
        return this.registry.containsKey(string);
    }

    public boolean registryHasElement(Element element) {
        return this.registry.contains(element);
    }

    public Element removeElementFromRegistry(String string) {
        this.registry.remove(string);
        this.registryList.removeElement(string);
        return this;
    }

    public Element removeElementFromRegistry(Element element) {
        this.removeElementFromRegistry(Integer.toString(element.hashCode()));
        return this;
    }
}

