/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema.identity;

import org.apache.xerces.framework.XMLAttrList;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.FieldActivator;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.XPath;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.apache.xerces.validators.schema.identity.XPathMatcher;

public class Selector {
    protected XPath fXPath;
    protected IdentityConstraint fIdentityConstraint;

    public Selector(XPath xPath, IdentityConstraint identityConstraint) {
        this.fXPath = xPath;
        this.fIdentityConstraint = identityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator fieldActivator) {
        return new Matcher(this.fXPath, fieldActivator);
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public org.apache.xerces.validators.schema.identity.XPath getXPath() {
        return this.fXPath;
    }

    public String toString() {
        return this.fXPath.toString();
    }

    public static class XPath
    extends org.apache.xerces.validators.schema.identity.XPath {
        public XPath(String string, StringPool stringPool, NamespacesScope namespacesScope, int n) throws XPathException {
            super("./" + string, stringPool, namespacesScope, n);
            XPath.Axis axis = this.fLocationPath.steps[this.fLocationPath.steps.length - 1].axis;
            if (axis.type == 2) {
                throw new XPathException("selectors cannot select attributes");
            }
        }
    }

    protected class Matcher
    extends XPathMatcher {
        protected FieldActivator fFieldActivator;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public Matcher(XPath xPath, FieldActivator fieldActivator) {
            super(xPath);
            this.fFieldActivator = fieldActivator;
        }

        public void endElement(QName qName) throws Exception {
            super.endElement(qName);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint);
            }
        }

        public void startDocumentFragment(StringPool stringPool, NamespacesScope namespacesScope) throws Exception {
            super.startDocumentFragment(stringPool, namespacesScope);
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        public void startElement(QName qName, XMLAttrList xMLAttrList, int n) throws Exception {
            super.startElement(qName, xMLAttrList, n);
            ++this.fElementDepth;
            if (this.isMatched()) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint);
                int n2 = Selector.this.fIdentityConstraint.getFieldCount();
                int n3 = 0;
                while (n3 < n2) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(n3);
                    XPathMatcher xPathMatcher = this.fFieldActivator.activateField(field);
                    xPathMatcher.startElement(qName, xMLAttrList, n);
                    ++n3;
                }
            }
        }
    }
}

