/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.InitException;
import org.webmacro.NotFoundException;
import org.webmacro.Template;
import org.webmacro.WM;
import org.webmacro.WebMacro;
import org.webmacro.servlet.ErrorHandler;
import org.webmacro.servlet.HandlerException;
import org.webmacro.servlet.WebContext;
import org.webmacro.util.Log;
import org.webmacro.util.SimpleStack;

public abstract class WMServlet
extends HttpServlet
implements WebMacro {
    private WebMacro _wm = null;
    private Broker _broker = null;
    private WebContext _wcPrototype;
    private boolean _started = false;
    private final SimpleStack _writerCache = new SimpleStack();
    static final String ERROR_VARIABLE = "ErrorVariable";
    static final String ERROR_TEMPLATE = "ErrorTemplate";
    static final String ERROR_TEMPLATE_DEFAULT = "error.wm";
    private static final Log _log = new Log("WMServlet", "WebMacro Abstract Servlet");
    private String _problem = "Not yet initialized: Your servlet API tried to access WebMacro without first calling init()!!!";

    public final synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.init();
    }

    public final synchronized void init() {
        if (this._started) {
            return;
        }
        if (this._wm == null) {
            try {
                this._wm = this.initWebMacro();
                this._broker = this._wm.getBroker();
            }
            catch (InitException initException) {
                _log.exception(initException);
                _log.error("Could not initialize the broker!\n*** Check that WebMacro.properties was in your servlet\n*** classpath, in a similar place to webmacro.jar \n*** and that all values were set correctly.\n");
                this._problem = initException.getMessage();
                return;
            }
        }
        try {
            this._wcPrototype = this.initWebContext();
        }
        catch (InitException initException) {
            _log.exception(initException);
            _log.error("Failed to initialize a WebContext, the initWebContext\nmethod returned an exception: " + initException);
            this._problem = initException.getMessage();
            return;
        }
        try {
            this.start();
            this._problem = null;
        }
        catch (ServletException servletException) {
            _log.exception((Object)servletException);
            this._problem = "WebMacro application code failed to initialize: \n" + (Object)((Object)servletException) + "\n" + "This error is the result of a failure in the\n" + "code supplied by the application programmer.\n";
        }
        this._started = true;
    }

    public final synchronized void destroy() {
        this.stop();
        this._wm.destroy();
        this._wm = null;
        this._started = false;
        this._writerCache.clear();
        super.destroy();
    }

    public final boolean isDestroyed() {
        return this._wm.isDestroyed();
    }

    protected final void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    protected final void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    private final void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        WebContext webContext = null;
        if (this._problem != null) {
            this.init();
            if (this._problem != null) {
                try {
                    httpServletResponse.setContentType("text/html");
                    FastWriter fastWriter = new FastWriter((OutputStream)httpServletResponse.getOutputStream(), httpServletResponse.getCharacterEncoding());
                    fastWriter.write("<html><head><title>WebMacro Error</title></head>");
                    fastWriter.write("<body><h1><font color=\"red\">WebMacro Error: ");
                    fastWriter.write("</font></h1><pre>");
                    fastWriter.write(this._problem);
                    fastWriter.write("</pre>");
                    fastWriter.write("Please contat the server administrator");
                    fastWriter.flush();
                    fastWriter.close();
                }
                catch (Exception exception) {
                    _log.error(this._problem);
                }
                return;
            }
        }
        try {
            webContext = this.newContext(httpServletRequest, httpServletResponse);
            Template template = this.handle(webContext);
            if (template != null) {
                this.execute(template, webContext);
            }
            this.destroyContext(webContext);
        }
        catch (HandlerException handlerException) {
            if (webContext == null) {
                webContext = this._wcPrototype.newInstance(httpServletRequest, httpServletResponse);
            }
            _log.exception(handlerException);
            Template template = this.error(webContext, "Your handler was unable to process the request successfully for some reason. Here are the details:<p>" + handlerException);
            this.execute(template, webContext);
        }
        catch (Exception exception) {
            if (webContext == null) {
                webContext = this._wcPrototype.newInstance(httpServletRequest, httpServletResponse);
            }
            _log.exception(exception);
            Template template = this.error(webContext, "The handler WebMacro used to handle this request failed for some reason. This is likely a bug in the handler written for this application. Here are the details:<p>" + exception);
            this.execute(template, this._wcPrototype.newInstance(httpServletRequest, httpServletResponse));
        }
    }

    protected final Template error(WebContext webContext, String string) {
        Template template = null;
        _log.warning(string);
        ErrorHandler errorHandler = new ErrorHandler();
        try {
            webContext.put(this.getConfig(ERROR_VARIABLE), string);
            template = errorHandler.accept(webContext);
        }
        catch (NotFoundException notFoundException) {
            _log.error("Could not find error variable in Config: " + notFoundException);
        }
        catch (Exception exception) {
            _log.error("Unable to use ErrorHandler: " + exception);
        }
        return template;
    }

    public final Broker getBroker() {
        return this._broker;
    }

    public final Template getTemplate(String string) throws NotFoundException {
        return this._wm.getTemplate(string);
    }

    public final Object getURL(String string) throws NotFoundException {
        return this._wm.getURL(string);
    }

    public final String getConfig(String string) throws NotFoundException {
        return this._wm.getConfig(string);
    }

    public final Context getContext() {
        return this._wm.getContext();
    }

    public final WebContext getWebContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this._wm.getWebContext(httpServletRequest, httpServletResponse);
    }

    /*
     * Loose catch block
     */
    protected final void execute(Template template, WebContext webContext) {
        block18: {
            Writer writer = null;
            FastWriter fastWriter = (FastWriter)this._writerCache.pop();
            HttpServletResponse httpServletResponse = webContext.getResponse();
            if (fastWriter == null) {
                fastWriter = new FastWriter((OutputStream)httpServletResponse.getOutputStream(), httpServletResponse.getCharacterEncoding());
            } else {
                fastWriter.recycle((OutputStream)httpServletResponse.getOutputStream(), httpServletResponse.getCharacterEncoding());
            }
            template.write(fastWriter, webContext);
            fastWriter.close();
            this._writerCache.push(fastWriter);
            Object var9_8 = null;
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
                break block18;
            }
            catch (Exception exception) {}
            break block18;
            {
                catch (IOException iOException) {
                    Object var9_9 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                            writer.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {}
                    break block18;
                }
                catch (Exception exception) {
                    _log.exception(exception);
                    String string = "WebMacro encountered an error while executing a  template:\n" + (template != null ? template + ": " + exception + "\n" : "The template failed to load; double check the TemplatePath in your webmacro.properties file.");
                    _log.warning(string);
                    try {
                        writer.write(string);
                    }
                    catch (Exception exception2) {
                    }
                    Object var9_10 = null;
                    try {
                        if (writer != null) {
                            writer.flush();
                            writer.close();
                        }
                        break block18;
                    }
                    catch (Exception exception3) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public WebContext newContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws HandlerException {
        return this._wcPrototype.newInstance(httpServletRequest, httpServletResponse);
    }

    public abstract Template handle(WebContext var1) throws HandlerException;

    public void destroyContext(WebContext webContext) throws HandlerException {
    }

    protected void start() throws ServletException {
    }

    protected void stop() {
    }

    public WebMacro initWebMacro() throws InitException {
        return new WM();
    }

    public WebContext initWebContext() throws InitException {
        return new WebContext(this._broker);
    }
}

