/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.engine.Engine;
import org.webmacro.engine.Variable;

final class PropertyVariable
extends Variable {
    PropertyVariable(Object[] objectArray) {
        super(objectArray);
    }

    public final Object getValue(Context context) throws ContextException {
        try {
            return context.getProperty(this._names);
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            String string = "Variable: unable to access " + this + ";";
            throw new ContextException(string);
        }
    }

    public final void setValue(Context context, Object object) throws ContextException {
        try {
            if (!context.setProperty(this._names, object)) {
                throw new ContextException("No method to set \"" + this._vname + "\" to type " + (object == null ? "null" : object.getClass().toString()) + " in supplied context (" + context.getClass() + ")");
            }
        }
        catch (Exception exception) {
            Engine.log.exception(exception);
            String string = "Variable.setValue: unable to access " + this + " (is it a public method/field?)";
            throw new ContextException(string);
        }
    }

    public final String toString() {
        return "property:" + this._vname;
    }
}

