/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.Macro;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Condition;
import org.webmacro.engine.Directive;
import org.webmacro.engine.Engine;
import org.webmacro.engine.MacroAdapter;

final class IfDirective
implements Directive {
    private final Condition myCondition;
    private final Macro myIfBlock;
    private final Macro myElseBlock;

    IfDirective(Condition condition, Macro macro, Macro macro2) {
        this.myCondition = condition;
        this.myIfBlock = macro;
        this.myElseBlock = macro2;
    }

    public static final String[] getSubDirectives() {
        String[] stringArray = new String[]{"else"};
        return stringArray;
    }

    public static final Object build(BuildContext buildContext, Condition condition, Macro macro, Object object) throws BuildException {
        if (condition instanceof Macro) {
            Macro macro2 = object != null ? MacroAdapter.createMacro(object, buildContext.getEncoding()) : null;
            return new IfDirective(condition, macro, macro2);
        }
        return condition.test(buildContext) ? macro : object;
    }

    public static final String[] getSubordinateNames() {
        String[] stringArray = new String[]{"else"};
        return stringArray;
    }

    public Object evaluate(Context context) throws ContextException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            FastWriter fastWriter = new FastWriter(byteArrayOutputStream, "UTF8");
            this.write(fastWriter, context);
            fastWriter.flush();
            return byteArrayOutputStream.toString("UTF8");
        }
        catch (IOException iOException) {
            Engine.log.exception(iOException);
            Engine.log.error("If: evaluate got IO exception on write to StringWriter");
            return "";
        }
    }

    public void write(FastWriter fastWriter, Context context) throws ContextException, IOException {
        Engine.log.debug("If: evaluating #if condition:" + this.myCondition);
        if (this.myCondition.test(context)) {
            Engine.log.debug("If: writing myIfBlock");
            if (this.myIfBlock != null) {
                this.myIfBlock.write(fastWriter, context);
            } else {
                Engine.log.warning("If: Block for an #if directive was null");
            }
        } else if (this.myElseBlock != null) {
            Engine.log.debug("If: writing myElseBlock: " + this.myCondition);
            this.myElseBlock.write(fastWriter, context);
        }
    }
}

