/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro;

import org.webmacro.Broker;
import org.webmacro.InitException;
import org.webmacro.WM;
import org.webmacro.broker.ResourceBroker;

final class BrokerOwner {
    String _config;
    private ResourceBroker _broker;
    private static int _brokerUsers = 0;

    BrokerOwner() {
        this(null);
    }

    BrokerOwner(String string) {
        this._config = string;
        this._broker = null;
        _brokerUsers = 0;
    }

    synchronized Broker init() throws InitException {
        ++_brokerUsers;
        if (this._broker == null) {
            try {
                this._broker = this._config == null ? new ResourceBroker() : new ResourceBroker(this._config);
            }
            catch (InitException initException) {
                this._broker = null;
                _brokerUsers = 0;
                WM._log.exception(initException);
                throw initException;
            }
            catch (Throwable throwable) {
                this._broker = null;
                _brokerUsers = 0;
                WM._log.exception(throwable);
                throw new InitException("An unexpected exception was raised during initialization. This is bad,\nthere is either a bug in WebMacro, or your configuration is messed up:\n" + throwable + "\nHere are some clues: if you got a ClassNotFound exception, either\n" + "something is missing from your classpath (odd since this code ran)\n" + "or your JVM is failing some important classfile due to bytecode problems\n" + "and then claiming that, it does not exist... you might also see some kind\n" + "of VerifyException or error in that case. If you suspect something like\n" + "this is happening, recompile the WebMacro base classes with your own Java\n" + "compiler and libraries--usually that helps. It could also be that your\n" + "JVM is not new enough. Again you could try recompiling, but if it is\n" + "older than Java 1.1.7 you might be out of luck. If none of this helps,\n" + "please join the WebMacro mailing list and let us know about the problem,\n" + "because yet another possibility is WebMacro has a bug--and anyway, we \n" + "might know a workaround, or at least like to hear about the bug.\n");
            }
        }
        return this._broker;
    }

    synchronized void done() {
        if (--_brokerUsers == 0 && this._broker != null) {
            this._broker.shutdown();
            this._broker = null;
        }
    }
}

