#include "defines.h"
#include "frend.h"
#include "interface.h"
#include "misc.h"
#include <time.h>

#ifndef S9X_PROFILER_H
#define S9X_PROFILER_H

#ifndef __GDK_H__
struct GdkPixmap;
struct GdkBitmap;
struct GdkEventButton;
#endif

#define S9X_PROFILE_NAME_LEN 50
#define S9X_PROFILE_ARGS_LEN 240

enum s9x_ProfileState {
   S9X_PROFILE_STATE_DEFAULT,
     S9X_PROFILE_STATE_SAVED,
     S9X_PROFILE_STATE_TEMP,
     S9X_PROFILE_STATE_DELETED
};

char*EncodedToString(char*s);

class s9x_Profiler :	public fr_Window, private fr_Listener {
 private:
   fr_Image		ImgApply, ImgSave, ImgDel, ImgDef, ImgTmp;
   fr_Label		Logo;
   fr_Text		ProfName;
   fr_Button		BtnOK, BtnCancel;
   fr_Button		BtnApply, BtnSave, BtnDef, BtnDel;
   fr_Box		BtnBox;
   fr_DataTable		ProfileList;
   s9x_FileOps		ProfileFile;
   bool			InLoading;
   void			CreateProfileList();
   void			CreateButtonBar();
   char			*NewProfileName;
   time_t		LastModified;
   int			LoadList();
   void			SetProfile(int r, s9x_ProfileState s, char*N, char*A);
   void			SetRowState(int row, s9x_ProfileState s);
   s9x_ProfileState	GetRowState(int row);
   void			ChangeState(s9x_ProfileState s);
   char*		GetRowName(int row);
   char*		GetRowArgsEncoded(int row);
   fr_ArgList*		GetRowArgList(int row);
   int			GetDefaultRow();
   int			GetSelectedRow();
   void			ApplyRow(int row);
   void			Apply();
   int			SaveList();
   void			EventOccurred(fr_Event*e);
 public:
			s9x_Profiler(s9x_Interface*parent);
			~s9x_Profiler();
   void			SetVisibility(bool s);
   void			RowSelected(int row);
   void			NameUpdated();
   void			ApplyDefaultProfile();
};
#endif
