/*
 * Decompiled with CFR 0.152.
 */
package com.arbortext.catalog;

import com.arbortext.catalog.CatalogEntry;
import com.arbortext.catalog.InvalidCatalogEntryException;
import com.arbortext.catalog.InvalidCatalogEntryTypeException;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class CatalogReader {
    private String catfilename = null;
    private DataInputStream catfile = null;
    private int[] stack = new int[3];
    private int top = -1;
    public int debug = 0;

    public CatalogReader() {
        String property = System.getProperty("xml.catalog.debug");
        if (property != null) {
            try {
                this.debug = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.debug = 0;
            }
        }
    }

    public void parseCatalog(String fileUrl) throws IOException, MalformedURLException {
        URL catalog;
        this.catfilename = fileUrl;
        try {
            catalog = new URL(fileUrl);
        }
        catch (MalformedURLException e) {
            catalog = new URL("file:///".concat(String.valueOf(String.valueOf(fileUrl))));
        }
        try {
            this.catfile = new DataInputStream(catalog.openStream());
        }
        catch (FileNotFoundException e) {
            this.debug(1, "Failed to load catalog, file not found", catalog.toString());
        }
    }

    protected void finalize() throws IOException {
        if (this.catfile != null) {
            this.catfile.close();
        }
        this.catfile = null;
    }

    public CatalogEntry nextEntry() throws IOException {
        if (this.catfile == null) {
            return null;
        }
        boolean confused = false;
        while (true) {
            String token;
            if ((token = this.nextToken()) == null) {
                this.catfile.close();
                this.catfile = null;
                return null;
            }
            if (token.equalsIgnoreCase("BASE") || token.equalsIgnoreCase("CATALOG") || token.equalsIgnoreCase("DOCUMENT") || token.equalsIgnoreCase("OVERRIDE") || token.equalsIgnoreCase("SGMLDECL")) {
                String spec = this.nextToken();
                confused = false;
                try {
                    CatalogEntry catalogEntry;
                    if (token.equalsIgnoreCase("BASE")) {
                        catalogEntry = new CatalogEntry(1, spec);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("CATALOG")) {
                        catalogEntry = new CatalogEntry(2, spec);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("DOCUMENT")) {
                        catalogEntry = new CatalogEntry(3, spec);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("OVERRIDE")) {
                        catalogEntry = new CatalogEntry(4, spec);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("SGMLDECL")) {
                        catalogEntry = new CatalogEntry(5, spec);
                        return catalogEntry;
                    }
                }
                catch (InvalidCatalogEntryTypeException icete) {
                    this.debug(1, "Invalid catalog entry type", token);
                    confused = true;
                }
                catch (InvalidCatalogEntryException icete) {
                    this.debug(1, "Invalid catalog entry", token, spec);
                    confused = true;
                }
            }
            if (token.equalsIgnoreCase("DELEGATE") || token.equalsIgnoreCase("DOCTYPE") || token.equalsIgnoreCase("DTDDECL") || token.equalsIgnoreCase("ENTITY") || token.equalsIgnoreCase("LINKTYPE") || token.equalsIgnoreCase("NOTATION") || token.equalsIgnoreCase("PUBLIC") || token.equalsIgnoreCase("SYSTEM")) {
                String spec1 = this.nextToken();
                String spec2 = this.nextToken();
                confused = false;
                try {
                    CatalogEntry catalogEntry;
                    if (token.equalsIgnoreCase("DELEGATE")) {
                        catalogEntry = new CatalogEntry(6, CatalogReader.normalize(spec1), spec2);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("DOCTYPE")) {
                        catalogEntry = new CatalogEntry(7, spec1, spec2);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("DTDDECL")) {
                        catalogEntry = new CatalogEntry(8, CatalogReader.normalize(spec1), spec2);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("ENTITY")) {
                        catalogEntry = new CatalogEntry(9, spec1, spec2);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("LINKTYPE")) {
                        catalogEntry = new CatalogEntry(10, spec1, spec2);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("NOTATION")) {
                        catalogEntry = new CatalogEntry(11, spec1, spec2);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("PUBLIC")) {
                        catalogEntry = new CatalogEntry(12, CatalogReader.normalize(spec1), spec2);
                        return catalogEntry;
                    }
                    if (token.equalsIgnoreCase("SYSTEM")) {
                        catalogEntry = new CatalogEntry(13, spec1, spec2);
                        return catalogEntry;
                    }
                }
                catch (InvalidCatalogEntryTypeException icete) {
                    this.debug(1, "Invalid catalog entry type", token);
                    confused = true;
                }
                catch (InvalidCatalogEntryException icete) {
                    this.debug(1, "Invalid catalog entry", token, spec1, spec2);
                    confused = true;
                }
            }
            if (confused) continue;
            if (this.debug > 1) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("Unrecognized token parsing catalog: '").append(this.catfilename).append("': ").append(token))));
                System.out.println("\tSkipping to next recognized token.");
            }
            confused = true;
        }
    }

    public static String normalize(String publicId) {
        int pos;
        String normal = publicId.replace('\t', ' ');
        normal = normal.replace('\r', ' ');
        normal = normal.replace('\n', ' ');
        normal = normal.trim();
        while ((pos = normal.indexOf("  ")) >= 0) {
            normal = String.valueOf(String.valueOf(normal.substring(0, pos))).concat(String.valueOf(String.valueOf(normal.substring(pos + 1))));
        }
        return normal;
    }

    private String nextToken() throws IOException {
        int nextch;
        int ch;
        String token = "";
        block0: while (true) {
            ch = this.catfile.read();
            while (ch <= 32) {
                ch = this.catfile.read();
                if (ch >= 0) continue;
                return null;
            }
            nextch = this.catfile.read();
            if (nextch < 0) {
                return null;
            }
            if (ch != 45 || nextch != 45) break;
            ch = 32;
            nextch = this.nextChar();
            while (true) {
                if (ch == 45 && nextch == 45) continue block0;
                ch = nextch;
                nextch = this.nextChar();
            }
            break;
        }
        this.stack[++this.top] = nextch;
        this.stack[++this.top] = ch;
        ch = this.nextChar();
        if (ch == 34 || ch == 39) {
            int quote = ch;
            while ((ch = this.nextChar()) != quote) {
                char[] chararr = new char[]{(char)ch};
                String s = new String(chararr);
                token = token.concat(s);
            }
            return token;
        }
        while (ch > 32) {
            nextch = this.nextChar();
            if (ch == 45 && nextch == 45) {
                this.stack[++this.top] = ch;
                this.stack[++this.top] = nextch;
                return token;
            }
            char[] chararr = new char[]{(char)ch};
            String s = new String(chararr);
            token = token.concat(s);
            ch = nextch;
        }
        return token;
    }

    private int nextChar() throws IOException {
        if (this.top < 0) {
            return this.catfile.read();
        }
        return this.stack[this.top--];
    }

    private void debug(int level, String message, String token) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(message))).append(": ").append(token))));
        }
    }

    private void debug(int level, String message, String token, String spec) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(message))).append(": ").append(token).append(" ").append(spec))));
        }
    }

    private void debug(int level, String message, String token, String spec1, String spec2) {
        if (this.debug >= level) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(message))).append(": ").append(token).append(" ").append(spec1))));
            System.out.println("\t".concat(String.valueOf(String.valueOf(spec2))));
        }
    }
}

