/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc;

import org.sablecc.sablecc.analysis.*;
import org.sablecc.sablecc.node.*;
import java.util.*;

public class Transitions extends DepthFirstAdapter
{
    public final Map tokenStates = new TypedTreeMap(
        NodeComparator.instance,
        NodeCast.instance,
        NoCast.instance);

    private String state;
    private String transition;
    private Map map;

    public void caseStateList1(StateList1 node)
    {
        inStateList1(node);

        node.getNode1().apply(this);
        node.getNode2().apply(this);
        node.getNode3().apply(this);

        outStateList1(node);  // We moved this...

        node.getNode4().apply(this);
        node.getNode5().apply(this);

    }

    public void inTokenDef1(TokenDef1 node)
    {
        map = new TypedTreeMap(
            StringComparator.instance,
            StringCast.instance,
            StringCast.instance);
    }

    public void inStateList1(StateList1 node)
    {
        state = transition = node.getNode2().getText().toUpperCase();
    }

    public void inStateListTail1(StateListTail1 node)
    {
        state = transition = node.getNode2().getText().toUpperCase();
    }

    public void outTransition1(Transition1 node)
    {
        transition = node.getNode2().getText().toUpperCase();
    }

    public void outStateList1(StateList1 node)
    {
        map.put(state, transition);
    }

    public void outStateListTail1(StateListTail1 node)
    {
        map.put(state, transition);
    }

    public void outTokenDef1(TokenDef1 node)
    {
        tokenStates.put(node, map);
    }
}
