\name{setDisplayEdges.ggobi}
\alias{setDisplayEdges.ggobi}
\title{Associate an edge set with a GGobi display}
\description{
 This sets the edges associated with 
 one or more GGobi displays and its plots.
 The user can specify
 whether the edges should be drawn as directed or undirected
 segments.
}
\usage{
setDisplayEdges.ggobi(displays, edgeData, directed=FALSE, on = TRUE, .gobi=getDefaultGGobi())
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{displays}{a list of \code{ggobiDisplay} objects
    which are to be changed to have  the specified edge set
    (\code{edgeData}) be the associations between the points.}
  \item{edgeData}{the dataset providing the edges/connections pairs}
  \item{directed}{a logical value indicating whether the edges
    should be displayed as directed line segments or simple lines.}
  \item{on}{a logical value indicating whether edges should be drawn or
    not. This can be used to turn off the visible edges.
  }
 \item{.gobi}{the GGobi instance in which to find the
   displays. This is needed if \code{displays} is specified
   using indices  rather than \code{ggobiDisplay} objects.
 }
}
\details{

}
\value{
  A list with the same number of elements
  as displays passed to this function.
  Each element contains a reference to the
  GGobi dataset that was used for edges
  for the display, or NULL if no edges
  were used.
}
\references{
\url{http://www.ggobi.org/RSggobi}
\url{http://www.ggobi.org}
}
\author{
Duncan Temple Lang
}
\note{
The edge mechanism in GGobi is general and powerful
and can be difficult to understand 
and can be slightly counter-intuitive for
simple cases. 
}

\seealso{
\code{\link{createEdgeData.ggobi}}
\code{\link{getEdges.ggobi}}
\code{\link{setEdges.ggobi}}
}

\examples{

}
\keyword{dynamic}
