\name{getDisplays.ggobi}
\alias{getDisplays.ggobi}
\title{Query the displays/windows of a ggobi instance.}
\description{
 This returns a list of display or plot windows references or
 full descriptions of each display
 owned by a particular ggobi instance.
}
\usage{
getDisplays.ggobi(describe = FALSE, .gobi=getDefaultGGobi())
}
\arguments{
  \item{describe}{a logical value indicating whether
  the full description should be returned (\code{TRUE}),
   or simply a reference to the display in the form of a
  code{ggobiDisplay}.}
  \item{.gobi}{the ggobi instance whose displays are to be described
   or referenced. This should be an object of class \code{ggobi} or an integer.}
}
\value{
A list with an element for each display 
in the ggobi instance.
If \code{describe} is specified as \code{TRUE},
each element
has $5$ components:
  \item{Name}{The title on the display's window.}
  \item{Type}{The type of display (e.g. scatterplot, parallel coordinat plot, \dots)
       given as a named integer vector whose value is the internal type
       code and whose name is a more descriptive identifier for the plot type.
     }
  \item{Plots}{A list describing each of the sub-plots within the display/window.
    Each element is a list containing 3 elements:
     \item{variables}{a named integer vector identifying the variables
       in the plot by both name and also index. (The indeces are problematic
        if one removes variables in the dataset).}
     \item{dataset}{an object of class \code{ggobiDataset} identifying the dataset in which the 
        variables are located.}
     \item{ggobi}{an object of class \code{ggobiInstance} specifying to which 
         ggobi the data and plot ``belong''.}
  }
  \item{dataset}{an object of class \code{ggobiDataset} which is a reference
     to the dataset that is associated with this display, i.e. which contains
     the variables in the different plots in this display.}
  \item{display}{an object of class \code{ggobiDisplay} which can be used to
    operate on the display and allows the need to refer to it by index.}

 If \code{describe} is \code{FALSE}, each element is
 an object of class \code{ggobiDisplay} and this is an opaque
 reference to the internal C-level dataset.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}

\seealso{ 
\code{\link{getPlotType.ggobi}}
\code{\link{getPlotCount.ggobi}}
}

\examples{
 g <- ggobi(system.file("data", "flea.xml", package="Rggobi"))
 g$scatmat(1:3)
   # Now see what we have.
 g$getDisplays(TRUE)

   # Get references to the displays and close the 
   # second one.
 close(g$getDisplays()[[2]])
}
\keyword{iplot}
\keyword{dynamic}
