\name{createDisplay.ggobi}
\alias{createDisplay.ggobi}
\title{Generic function to create a GGobi display}
\description{
  This is a generic mechanism to create a top-level GGobi
  display from R.
  It identifies the target display type and the corresponding
  Gtk class and invokes the method to create and populate the
  particular display with the given variables in the given dataset.
}
\usage{
createDisplay.ggobi(type, vars, .data = 1, .gobi = getDefaultGGobi())
}
\arguments{
  \item{type}{the name of the desired display type, which can be given
    either by the Gtk class name or by its more "human readable" form
   returned as the names of the elements from the function \code{\link{getDisplayTypes.ggobi}}}
 \item{vars}{the identifiers for the variables to be displayed in the
   plot(s). These can be either variable names or indices. They are
   resolved relative to the dataset \code{.data}.    
   }
  \item{.data}{the dataset identifier in which to resolve the variables \code{vars}.}
  \item{.gobi}{the ggobi instance in which to resolve the dataset if
    that is given as a name or index rather than a dataset reference.
  }
}
\details{

}
\value{
  An object of class \code{ggobiDisplay}.
  \item{id}{the integer identifier for the display}
  \item{ref}{a pointer to the C-level displayd object.}
  \item{ggobi}{the GGobi instance in which the display was created. This
  is an object of class \code{ggobi}. See \code{\link{ggobi-class}}.}
}

\references{
\url{http://www.ggobi.org}
\url{http://www.omegahat.org/RGtk}
}
\author{Duncan Temple Lang}

\seealso{
  \code{\link{scatterplot.ggobi}}
  \code{\link{scatmat.ggobi}}
  \code{\link{parcoords.ggobi}}  
}
\examples{

 data(mtcars)
 g = ggobi(mtcars)

 g$createDisplay("GtkGGobiScatterplotDisplay", c("cyl", "mpg"))
 

}
\keyword{iplot}
\keyword{dynamic}

