\name{parallelCoordDescription}
\alias{parallelCoordDescription}
\alias{scatterplotDescription}
\alias{scatmatrixDescription}
\alias{ashDescription}
\alias{timeseriesDescription}
\title{Create a plot description or template for use in plotLayout()}
\description{
 When creating composite plots in a single display/window,
 one first creates a description of each of the sub-plots
(e.g. scatterplot, parallel coordinates plot, ash, etc.)
 and then pass these virtual plots to \code{\link{plotLayout}}
 to instantiate them and lay them out within the display.
 These functions create the virtual plots in the form
 of a description.
}
\usage{
parallelCoordDescription(..., .data = -1, .gobi=NULL)
scatterplotDescription(x, y, .data = -1, .gobi=NULL)
scatmatrixDescription(..., .data = -1, .gobi=NULL)
ashDescription(x, .data = -1, .gobi=NULL)
timeseriesDescription(..., .data = -1, .gobi = NULL)
}
\arguments{
  \item{x,y}{variables to be displayed in the plot, given as 
     as a name, index.}
  \item{\dots}{the names or indices of the variables
that are to be displayed in the plot.}
  \item{.gobi}{optional ggobi instance with respect to which
the variables will be resolved. This can be specified
when the plot description is realized (e.g. in a call to 
\code{\link{plotLayout}})}
  \item{.data}{the index or name of the dataset 
within the ggobi instance in which the variable
identifiers are to be resolved.
}
}
\details{
  These descriptions are templates for how to create a
plot in the future. The descriptions can be created
before any ggobi is created.
The idea here is similar to having an expression
generated by \code{\link{quote}} or \code{\link{expression}}
that is to be evaluated at a subsequent time.
}
\value{
A list containing the arguments and whose class identifies the plot
type corresponding to which of these description functions was
invoked.
}

\references{\url{http://www.ggobi.org}, \url{http://www.ggobi.org/Rggobi}}
\author{Duncan Temple Lang}


\seealso{
\code{\link{plotLayout}}
}

\examples{
  plot4 <- ashDescription("tars2")
  plot5 <- scatmatrixDescription("tars1", "tars2", "head")
  plot6 <- parallelCoordDescription("tars1", "tars2", "head")
}
\keyword{visualization}
\keyword{interface}
