library("methods")

setOldClass("ggobi")
setOldClass("ggobiDataset")
setOldClass("ggobiDisplay")
setOldClass("ggobiDisplayDescription")



# Append argument is not in this version.

setGeneric("setEdges.ggobi",
            function(src, dest, edgeset, .gobi = getDefaultGGobi())
              standardGeneric("setEdges.ggobi"))


setMethod("setEdges.ggobi",
           c("ANY", "missing", "missing", "missing"),
          function(src, dest, edgeset, .gobi = getDefaultGGobi())
          {
             setEdges(src, dest, edgeset = .gobi[[1]], .gobi)
          })

 # Set the symbolic edges by creating a new edge dataset 
 # with no variables but just edge information.
setMethod("setEdges.ggobi",
           c("matrix", "missing", "missing", "missing"),
          function(src, dest, edgeset, .gobi = getDefaultGGobi())
          {

            if(nrow(src) == nrow(.gobi[[1]])) {
              edgeset <- .gobi[[1]]
            } else {
              edgeset <- createEdgeDataset.ggobi(nrow(src), .gobi =.gobi)
            }
            
#            if(mode(src) != "character") {
#                stop("Makes no sense")
#                # resolve the entries as indices into the rows of the dataset
#            }


             setEdges.ggobi(src, edgeset = edgeset, .gobi = .gobi)
           })


setMethod("setEdges.ggobi",
           c("matrix", "missing", "ggobiDataset"),
          function(src, dest, edgeset, .gobi = getDefaultGGobi())
          {
             if(mode(src) == "numeric") {
                return(setEdges.ggobi(src[,1], src[,2], edgeset = edgeset, .gobi = .gobi))
             } else if(mode(src) != "character")
               stop("Matrix must be numeric or character")

             setEdges.ggobi(src[,1], src[,2], edgeset = edgeset, .gobi = .gobi)

             invisible(edgeset)
           })



setMethod("setEdges.ggobi",
           c("data.frame", "missing", "ggobiDataset"),
          function(src, dest, edgeset, .gobi = getDefaultGGobi())
          {
             setEdges.ggobi(src[,1], src[,2], edgeset = edgeset, .gobi = .gobi)

             invisible(edgeset)
           })



setMethod("setEdges.ggobi",
          c("numeric", "numeric", "ggobiDataset"),
          function(src, dest, edgeset, .gobi = getDefaultGGobi())
          {
             ids <- rownames(edgeset)
           
             src <- ids[src]
             dest <- ids[dest]             
             
             setEdges.ggobi(src, dest, edgeset = edgeset, .gobi = .gobi)

             invisible(edgeset)
           })


setMethod("setEdges.ggobi",
           c("character", "character", "ggobiDataset"),
function(src, dest, edgeset, .gobi = getDefaultGGobi())
{          
#
# x and y are vectors of equal length identifying the points
# or a matrix with 2 columns.  
#
 if(length(src) != length(dest)) {
    m <- min(length(src),length(dest))

    length(src) <- m
    length(dest) <- m
 }

   v <- .GGobiCall("setEdges", src, dest, FALSE, edgeset, .gobi=.gobi)
})


removeEdges.ggobi =
  #
  # Special version of setEdges which is to remove all of the existing ones.
  #
function(edgeset = 1, .gobi = getDefaultGGobi())
{
  .GGobiCall("setEdges", character(0), character(0), FALSE, edgeset, .gobi =.gobi)
}
