/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.webservicebroker.provider;

 import org.xml.sax.*;
 import java.io.*;


 public class BrokerEntityResolver implements EntityResolver {
     
     private static String PACKAGE_LOCATION = "/com/sun/j2ee/blueprints/opc/webservicebroker/provider/";
     private static String BLUEPRINTS_NS = "http://java.sun.com/blueprints/schemas/";
     
     public InputSource resolveEntity (String publicId, String systemId) {
        if (systemId.equals(BLUEPRINTS_NS + "invoice.xsd")) {
            return getClassPathSource("invoice.xsd");
        } else if (systemId.equals(BLUEPRINTS_NS + "invoice-activity.xsd")) {
            return getClassPathSource("invoice-activity.xsd");
        } else if (systemId.equals(BLUEPRINTS_NS + "invoice-airline.xsd")) {
            return getClassPathSource("invoice-airline.xsd");
        } else if (systemId.equals(BLUEPRINTS_NS + "invoice-lodging.xsd")) {
            return getClassPathSource("invoice-lodging.xsd");
        } else {
            // use the default behaviour
            return null;
        }
   }
   
   private InputSource getClassPathSource(String name) {
       InputStream is =  null;
       try {
           is  = getClass().getResourceAsStream(PACKAGE_LOCATION + name);
           return new InputSource(is);
       } catch (Exception e) {
           System.err.println("BrokerEntityResolver error resolving: " + name);
           e.printStackTrace();
       }
       // default to the default entity resolver
       return null;
   }
 }
 
