/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.powebservice;

import java.util.*;
import java.rmi.*;

import javax.ejb.*;
import javax.jms.*;

import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;
import com.sun.j2ee.blueprints.opc.purchaseorder.*;
import com.sun.j2ee.blueprints.opc.JNDINames;
import com.sun.j2ee.blueprints.opc.utils.*;
import com.sun.j2ee.blueprints.opc.serviceexceptions.*;

/**
 *  This class is the entry point for purchase orders submitted 
 *  by adventure builder web site application when a user 
 *  submits an order.
 */
public class PoEndpointBean implements SessionBean {

    private SessionContext sc;
 
    public PoEndpointBean(){}
    
    public void ejbCreate() throws CreateException {}

    /**
     * Accept a purchase order, place the order in a JMS queue and return the 
     * order id so that the caller can have a correlation id for the order
     */
    public String submitPurchaseOrder(PurchaseOrder po)
  throws InvalidPOException, ProcessingException, RemoteException { 

        //validate PO, make sure all required info is provided.
        if (po == null) {
            throw new InvalidPOException("The Purchase Order received was empty!!!!");
        } else if ( po.getUserId()       == null || 
                    po.getEmailId()      == null || 
                    po.getLocale()       == null || 
                    po.getOrderDate()    == null ||
                    po.getShippingInfo() == null ||
                    po.getBillingInfo()  == null ||
                    po.getTotalPrice()   == 0    ||
                    po.getCreditCard()   == null ||
                    po.getHeadCount()    == 0    ||
                    po.getStartDate()    == null ||
                    po.getEndDate()      == null ||
                    po.getDepartureCity()== null  ) {
            throw new InvalidPOException("No field in the purchase order can be null!");
        }
  if(JMSUtils.sendMessage(JNDINames.WORKFLOW_MGR_MDB_QUEUE, 
        JNDINames.DOC_TYPE, JNDINames.PO_DOCUMENT, 
        (Object)po) == false)
      throw new ProcessingException("Irrecoverable error while submitting the order for processing");
        return po.getPoId();
    }
        
    public void setSessionContext(SessionContext sc) {
        this.sc = sc;
    }
    
    public void ejbRemove() throws RemoteException {}    

    //empty for Stateless EJBs
    public void ejbActivate() {}

    //empty for Stateless EJBs
    public void ejbPassivate() {}
   
}
