<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" version="1.0">

  <xsl:output method="html" indent="yes"/>

  <!-- template rule matching source root element -->
  <xsl:template match="/">
    <html> <head> 
    <title>Java AVK for the Enterprise Report Tool </title>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
    <LINK href="./appVerification.css" rel="stylesheet" type="text/css"> 
    </LINK>
    </meta>
    </head>

    <xsl:apply-templates select="app-verification"/>
    </html>
  </xsl:template>

  <xsl:template match="app-verification">
     <body bgcolor="#FFFFFF" background="./Lt_BluePaperTexture.gif">
     <form method="post" action="">
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
           <tr bgcolor="7171A5">
             <td width="100%"> 
                <div class="page-title-text" align="left">Java AVK for the Enterprise - EJB Method Coverage </div>
             </td>
           </tr>
        </table>

        <xsl:for-each select="percentage/bean-percentage">
  <table border="0" cellspacing="0" cellpadding="0" width="100%">
   <tr height="1">
   <td class="line-row" colspan="2" alt="" width="1" height="1" border="0"/>
   </tr>
   <tr>
   <td width="35%" valign="top">
      <div class="table-title-text">Application File: </div>
    </td>
    <td width="65%"> 
      <div class="table-normal-text"> <xsl:value-of select="./app-name"/> </div>
    </td>
   </tr>
   <tr>
   <td width="35%" valign="top">
      <div class="table-title-text">Status: </div>          
    </td>
    <td width="65%"> 
        <xsl:variable name="ejb-percent" select="normalize-space(./ejb-percentage)"/>
	<xsl:choose>
	   <xsl:when test="$ejb-percent &lt; '80'">
              <div class="table-failed-text">Failed <xsl:value-of select="./ejb-percentage"/>% of all methods called </div>
	   </xsl:when>
	   <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="count(//enterprise-bean/method/exception) != 0">
                <div class="table-failed-text">Failed <xsl:value-of select="ejb-percentage"/>% of methods called, exceptions found </div>
              </xsl:when>
              <xsl:otherwise>
                <div class="table-normal-text">Passed <xsl:value-of select="./ejb-percentage"/>% of all methods called </div>
	     </xsl:otherwise>
            </xsl:choose>
	   </xsl:otherwise>
         </xsl:choose>
      </td>
    </tr>
  </table>

	<xsl:variable name="app" select="./app-name"/>
          <br>
          <table class="back-table" border="0" cellspacing="0" cellpadding="1" width="100%">
            <tr> 
            <td> 
            <table class="front-table" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr class="header-row"> 
              <td width="35%"> 
              <div class="table-header-text" align="left">EJB Jar File </div>
              </td>
              <td width="40%"> 
                  <div class="table-header-text" align="left">Bean Name </div>
              </td>
              <td width="25%"> 
              <div class="table-header-text" align="left">Methods Called </div>
              </td>
              </tr>
	      <xsl:for-each select="//enterprise-bean">
	        <xsl:variable name="thisApp" select="app-name"/>
	        <xsl:if test="$app = $thisApp">
		<xsl:variable name="jar" select="normalize-space(jar-name)"/>
		<xsl:variable name="bean" select="normalize-space(bean-name)"/>
                <tr height="1">
                  <td class="line-row" colspan="3"><img src="./dot.gif" alt="" width="1" height="1" border="0"/></td>
                </tr>
                <tr> 
                <td width="25%" valign="top"> 
                <div class="table-normal-text"><xsl:value-of select="jar-name"/> </div>
                </td>
                 <td width="55%" valign="top"> 
                 <div class="table-normal-text"><a href="ejbDetail.html#{$thisApp}{$jar}{$bean}"><xsl:value-of select="bean-name"/> </a></div>
                 </td>
                 <td width="20%" valign="bottom"> 
		   <xsl:for-each select="method">
		   </xsl:for-each>
                   <div class="table-normal-text"> <xsl:value-of select="count(method/counter[.!=0])"/>/ <xsl:value-of select="count(method/method-signature)"/> </div>
	         </td>
	         </tr>
 		</xsl:if> 
	       </xsl:for-each>
	       </table>
	    </td>
	    </tr>
	    </table>
          </br>

	</xsl:for-each>
     </form>
     </body>
  </xsl:template>


<xsl:template/>
</xsl:stylesheet>