/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.xslt.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.netbeans.modules.xslt.model.Attribute;
import org.netbeans.modules.xslt.model.Choose;
import org.netbeans.modules.xslt.model.Otherwise;
import org.netbeans.modules.xslt.model.When;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslVisitor;
import org.w3c.dom.Element;


/**
 * @author ads
 *
 */
class ChooseImpl extends SequenceElementImpl implements Choose {

    ChooseImpl( XslModelImpl model, Element element ) {
        super( model , element );
    }
    
    ChooseImpl( XslModelImpl model ){
        super( model , XslElements.CHOOSE );
    }
    

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#accept(org.netbeans.modules.xslt.model.XslVisitor)
     */
    @Override
    public void accept( XslVisitor visitor )
    {
        visitor.visit( this );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.impl.XslComponentImpl#getComponentType()
     */
    @Override
    public Class<? extends XslComponent> getComponentType()
    {
        return Choose.class;
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Choose#addWhen(org.netbeans.modules.xslt.model.When, int)
     */
    public void addWhen( When when, int position ) {
        insertAtIndex( WHEN_PROPERTY, when, position,
                Attribute.class );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Choose#appendWhen(org.netbeans.modules.xslt.model.When)
     */
    public void appendWhen( When when ) {
        addBefore( WHEN_PROPERTY, when, OTHERWISE_COLLECTION );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Choose#getOtherwise()
     */
    public Otherwise getOtherwise() {
        return getChild( Otherwise.class );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Choose#getWhens()
     */
    public List<When> getWhens() {
        return getChildren( When.class );
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Choose#removeWhen(org.netbeans.modules.xslt.model.When)
     */
    public void removeWhen( When when ) {
        removeChild( WHEN_PROPERTY , when);
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.xslt.model.Choose#setOtherwise(org.netbeans.modules.xslt.model.Otherwise)
     */
    public void setOtherwise( Otherwise otherwise ) {
        setChildBefore( Otherwise.class , OTHERWISE_PROPERTY , otherwise , EMPTY );
    }

    private static final Collection<Class<? extends XslComponent>> 
        OTHERWISE_COLLECTION = new ArrayList<Class<? extends XslComponent>>(1);
    
    static {
        OTHERWISE_COLLECTION.add( Otherwise.class );
    }
}
