/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.xslt.model;

import java.util.List;

import javax.xml.namespace.QName;


/**
 * <pre>
 * &lt;xs:element name="apply-templates" substitutionGroup="xsl:instruction">
 *  &lt;xs:complexType>
 *      &lt;xs:complexContent>
 *          &lt;xs:extension base="xsl:element-only-versioned-element-type">
 *              &lt;xs:choice minOccurs="0" maxOccurs="unbounded">
 *                  &lt;xs:element ref="xsl:sort"/>
 *                  &lt;xs:element ref="xsl:with-param"/>
 *              &lt;/xs:choice>
 *              &lt;xs:attribute name="select" type="xsl:expression" default="child::node()"/>
 *              &lt;xs:attribute name="mode" type="xsl:mode"/>
 *          &lt;/xs:extension>
 *      &lt;/xs:complexContent>
 *  &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 * 
 * @author ads
 *
 */
public interface ApplyTemplates extends Instruction, SelectSpec {
    
    String CHILD_ELEMENTS   = "sort_or_with-param";        // NOI18N
    
    String MODE             = "mode";                      // NOI18N

    /**
     * @return list of ApplyTemplates children components
     */
    List<ApplyTemplateChild> getChildrenElements();
    
    /**
     * Appends new <code>child</code> to the end of children list.
     * @param child new child component 
     */
    void appendChildElement( ApplyTemplateChild child );
    
    /**
     * Insert new <code>child</code> into <code>position</code>.
     * @param child new child element.
     * @param position position index
     */
    void addChildElement( ApplyTemplateChild child , int position );
    
    /**
     * Removes <code>child</code> component.  
     * @param child child in this parent
     */
    void removeChildElement( ApplyTemplateChild child );
    
    /**
     * Gets the mode of this template.
     * @return the mode
     */
    QName getMode();
    
    
    /**
     * Sets the mode of this template.
     * @param mode the new mode for this template
     */
    void setMode(QName  mode);
}
